/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algorithm.EditDistance;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionary;
import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionaryEx;
import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.ArrayList;
import java.util.List;

public class CoreSynonymDictionaryEx {
    static CommonSynonymDictionaryEx dictionary;

    static {
        try {
            dictionary = CommonSynonymDictionaryEx.create(IOUtil.newInputStream(HanLP.Config.CoreSynonymDictionaryDictionaryPath));
        }
        catch (Exception e) {
            Predefine.logger.severe("\u8f7d\u5165\u6838\u5fc3\u540c\u4e49\u8bcd\u8bcd\u5178\u5931\u8d25" + e);
            System.exit(-1);
        }
    }

    public static Long[] get(String key) {
        return dictionary.get(key);
    }

    public static long distance(CommonSynonymDictionary.SynonymItem itemA, CommonSynonymDictionary.SynonymItem itemB) {
        return itemA.distance(itemB);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Long[]> convert(List<Term> sentence, boolean withUndefinedItem) {
        ArrayList<Long[]> synonymItemList = new ArrayList<Long[]>(sentence.size());
        block4: for (Term term : sentence) {
            if (term.nature == null) continue;
            String nature = term.nature.toString();
            char firstChar = nature.charAt(0);
            switch (firstChar) {
                case 'm': {
                    if (TextUtility.isAllChinese(term.word)) break;
                    continue block4;
                }
                case 'w': {
                    continue block4;
                }
            }
            if (CoreStopWordDictionary.contains(term.word)) continue;
            Long[] item = CoreSynonymDictionaryEx.get(term.word);
            if (item == null) {
                if (!withUndefinedItem) continue;
                item = new Long[]{0x2AAAAAAAAAAAAAAAL};
                synonymItemList.add(item);
                continue;
            }
            synonymItemList.add(item);
        }
        return synonymItemList;
    }

    public static long[] getLexemeArray(List<CommonSynonymDictionary.SynonymItem> synonymItemList) {
        long[] array = new long[synonymItemList.size()];
        int i = 0;
        for (CommonSynonymDictionary.SynonymItem item : synonymItemList) {
            array[i++] = item.entry.id;
        }
        return array;
    }

    public long distance(List<CommonSynonymDictionary.SynonymItem> synonymItemListA, List<CommonSynonymDictionary.SynonymItem> synonymItemListB) {
        return EditDistance.compute(synonymItemListA, synonymItemListB);
    }

    public long distance(long[] arrayA, long[] arrayB) {
        return EditDistance.compute(arrayA, arrayB);
    }
}

