/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;

public class TransformMatrixDictionary<E extends Enum<E>> {
    Class<E> enumType;
    private int ordinaryMax;
    int[][] matrix;
    int[] total;
    int totalFrequency;
    public int[] states;
    public double[] start_probability;
    public double[][] transititon_probability;

    public TransformMatrixDictionary(Class<E> enumType) {
        this.enumType = enumType;
    }

    public boolean load(String path) {
        try {
            int i;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            String line = br.readLine();
            String[] _param = line.split(",");
            String[] labels = new String[_param.length - 1];
            System.arraycopy(_param, 1, labels, 0, labels.length);
            int[] ordinaryArray = new int[labels.length];
            this.ordinaryMax = 0;
            int i2 = 0;
            while (i2 < ordinaryArray.length) {
                ordinaryArray[i2] = ((Enum)this.convert(labels[i2])).ordinal();
                this.ordinaryMax = Math.max(this.ordinaryMax, ordinaryArray[i2]);
                ++i2;
            }
            ++this.ordinaryMax;
            this.matrix = new int[this.ordinaryMax][this.ordinaryMax];
            i2 = 0;
            while (i2 < this.ordinaryMax) {
                int j = 0;
                while (j < this.ordinaryMax) {
                    this.matrix[i2][j] = 0;
                    ++j;
                }
                ++i2;
            }
            while ((line = br.readLine()) != null) {
                String[] paramArray = line.split(",");
                int currentOrdinary = ((Enum)this.convert(paramArray[0])).ordinal();
                int i3 = 0;
                while (i3 < ordinaryArray.length) {
                    this.matrix[currentOrdinary][ordinaryArray[i3]] = Integer.valueOf(paramArray[1 + i3]);
                    ++i3;
                }
            }
            br.close();
            this.total = new int[this.ordinaryMax];
            int j = 0;
            while (j < this.ordinaryMax) {
                this.total[j] = 0;
                i = 0;
                while (i < this.ordinaryMax) {
                    int n = j;
                    this.total[n] = this.total[n] + this.matrix[j][i];
                    ++i;
                }
                ++j;
            }
            j = 0;
            while (j < this.ordinaryMax) {
                if (this.total[j] == 0) {
                    i = 0;
                    while (i < this.ordinaryMax) {
                        int n = j;
                        this.total[n] = this.total[n] + this.matrix[i][j];
                        ++i;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < this.ordinaryMax) {
                this.totalFrequency += this.total[j];
                ++j;
            }
            this.states = ordinaryArray;
            this.start_probability = new double[this.ordinaryMax];
            int[] nArray = this.states;
            int n = this.states.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                double frequency = (double)this.total[s] + 1.0E-8;
                this.start_probability[s] = -Math.log(frequency / (double)this.totalFrequency);
                ++n2;
            }
            this.transititon_probability = new double[this.ordinaryMax][this.ordinaryMax];
            nArray = this.states;
            n = this.states.length;
            n2 = 0;
            while (n2 < n) {
                int from = nArray[n2];
                int[] nArray2 = this.states;
                int n3 = this.states.length;
                int n4 = 0;
                while (n4 < n3) {
                    int to = nArray2[n4];
                    double frequency = (double)this.matrix[from][to] + 1.0E-8;
                    this.transititon_probability[from][to] = -Math.log(frequency / (double)this.total[from]);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
        }
        return true;
    }

    public int getFrequency(String from, String to) {
        return this.getFrequency(this.convert(from), this.convert(to));
    }

    public int getFrequency(E from, E to) {
        return this.matrix[((Enum)from).ordinal()][((Enum)to).ordinal()];
    }

    public int getTotalFrequency(E e) {
        return this.total[((Enum)e).ordinal()];
    }

    public int getTotalFrequency() {
        return this.totalFrequency;
    }

    protected E convert(String label) {
        return Enum.valueOf(this.enumType, label);
    }

    public void extendSize() {
        ++this.ordinaryMax;
        double[][] n_transititon_probability = new double[this.ordinaryMax][this.ordinaryMax];
        int i = 0;
        while (i < this.transititon_probability.length) {
            System.arraycopy(this.transititon_probability[i], 0, n_transititon_probability[i], 0, this.transititon_probability.length);
            ++i;
        }
        this.transititon_probability = n_transititon_probability;
        int[] n_total = new int[this.ordinaryMax];
        System.arraycopy(this.total, 0, n_total, 0, this.total.length);
        this.total = n_total;
        double[] n_start_probability = new double[this.ordinaryMax];
        System.arraycopy(this.start_probability, 0, n_start_probability, 0, this.start_probability.length);
        this.start_probability = n_start_probability;
        int[][] n_matrix = new int[this.ordinaryMax][this.ordinaryMax];
        int i2 = 0;
        while (i2 < this.matrix.length) {
            System.arraycopy(this.matrix[i2], 0, n_matrix[i2], 0, this.matrix.length);
            ++i2;
        }
        this.matrix = n_matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransformMatrixDictionary{");
        sb.append("enumType=").append(this.enumType);
        sb.append(", ordinaryMax=").append(this.ordinaryMax);
        sb.append(", matrix=").append(Arrays.toString((Object[])this.matrix));
        sb.append(", total=").append(Arrays.toString(this.total));
        sb.append(", totalFrequency=").append(this.totalFrequency);
        sb.append('}');
        return sb.toString();
    }
}

