/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CommonStringDictionary {
    BinTrie<Byte> trie;

    public boolean load(String path) {
        this.trie = new BinTrie();
        if (this.loadDat(String.valueOf(path) + ".trie.dat")) {
            return true;
        }
        String line = null;
        try {
            BufferedReader bw = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path)));
            while ((line = bw.readLine()) != null) {
                this.trie.put(line, null);
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u52a0\u8f7d" + path + "\u5931\u8d25\uff0c" + e);
        }
        if (!this.trie.save(String.valueOf(path) + ".trie.dat")) {
            Predefine.logger.warning("\u7f13\u5b58" + path + ".trie.dat" + "\u5931\u8d25");
        }
        return true;
    }

    boolean loadDat(String path) {
        return this.trie.load(path);
    }

    public Set<String> keySet() {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (Map.Entry<String, Byte> entry : this.trie.entrySet()) {
            keySet.add(entry.getKey());
        }
        return keySet;
    }
}

