/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.dictionary.common.CommonDictionary;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public abstract class EnumItemDictionary<E extends Enum<E>>
extends CommonDictionary<EnumItem<E>> {
    @Override
    protected EnumItem<E> createValue(String[] params) {
        Map.Entry<String, Map.Entry<String, Integer>[]> args = EnumItem.create(params);
        EnumItem nrEnumItem = new EnumItem();
        Map.Entry<String, Integer>[] entryArray = args.getValue();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<String, Integer> e = entryArray[n2];
            nrEnumItem.labelMap.put(this.valueOf(e.getKey()), e.getValue());
            ++n2;
        }
        return nrEnumItem;
    }

    protected abstract E valueOf(String var1);

    protected abstract E[] values();

    protected abstract EnumItem<E> newItem();

    protected final EnumItem<E>[] loadValueArray(ByteArray byteArray) {
        if (byteArray == null) {
            return null;
        }
        Enum[] nrArray = this.values();
        int size = byteArray.nextInt();
        EnumItem[] valueArray = new EnumItem[size];
        int i = 0;
        while (i < size) {
            int currentSize = byteArray.nextInt();
            EnumItem<E> item = this.newItem();
            int j = 0;
            while (j < currentSize) {
                Enum nr = nrArray[byteArray.nextInt()];
                int frequency = byteArray.nextInt();
                item.labelMap.put(nr, frequency);
                ++j;
            }
            valueArray[i] = item;
            ++i;
        }
        return valueArray;
    }

    @Override
    protected void saveValue(EnumItem<E> item, DataOutputStream out) throws IOException {
        out.writeInt(item.labelMap.size());
        for (Map.Entry entry : item.labelMap.entrySet()) {
            out.writeInt(((Enum)entry.getKey()).ordinal());
            out.writeInt(entry.getValue());
        }
    }
}

