/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.nr;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;

public class TranslatedPersonDictionary {
    static String path = HanLP.Config.TranslatedPersonDictionaryPath;
    static DoubleArrayTrie<Boolean> trie;

    static {
        long start = System.currentTimeMillis();
        if (!TranslatedPersonDictionary.load()) {
            throw new IllegalArgumentException("\u97f3\u8bd1\u4eba\u540d\u8bcd\u5178" + path + "\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info("\u97f3\u8bd1\u4eba\u540d\u8bcd\u5178" + path + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    static boolean load() {
        trie = new DoubleArrayTrie();
        if (TranslatedPersonDictionary.loadDat()) {
            return true;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
            TreeMap<Character, Integer> charFrequencyMap = new TreeMap<Character, Integer>();
            while ((line = br.readLine()) != null) {
                map.put(line, true);
                char[] cArray = line.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if ("\u4e0d\u8d5e".indexOf(c) < 0) {
                        Integer f = (Integer)charFrequencyMap.get(Character.valueOf(c));
                        if (f == null) {
                            f = 0;
                        }
                        charFrequencyMap.put(Character.valueOf(c), f + 1);
                    }
                    ++n2;
                }
            }
            br.close();
            map.put(String.valueOf('\u00b7'), true);
            for (Map.Entry entry : charFrequencyMap.entrySet()) {
                if ((Integer)entry.getValue() < 10) continue;
                map.put(String.valueOf(entry.getKey()), true);
            }
            Predefine.logger.info("\u97f3\u8bd1\u4eba\u540d\u8bcd\u5178" + path + "\u5f00\u59cb\u6784\u5efa\u53cc\u6570\u7ec4\u2026\u2026");
            trie.build(map);
            Predefine.logger.info("\u97f3\u8bd1\u4eba\u540d\u8bcd\u5178" + path + "\u5f00\u59cb\u7f16\u8bd1DAT\u6587\u4ef6\u2026\u2026");
            Predefine.logger.info("\u97f3\u8bd1\u4eba\u540d\u8bcd\u5178" + path + "\u7f16\u8bd1\u7ed3\u679c\uff1a" + TranslatedPersonDictionary.saveDat(map));
        }
        catch (Exception e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        return true;
    }

    static boolean saveDat(TreeMap<String, Boolean> map) {
        return trie.save(String.valueOf(path) + ".trie.dat");
    }

    static boolean loadDat() {
        return trie.load(String.valueOf(path) + ".trie.dat");
    }

    public static boolean containsKey(String key) {
        return trie.containsKey(key);
    }

    public static boolean containsKey(String key, int length) {
        if (!trie.containsKey(key)) {
            return false;
        }
        return key.length() >= length;
    }
}

