/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.other;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.ObjectInputStream;

public class CharTable {
    public static char[] CONVERT;

    static {
        long start = System.currentTimeMillis();
        if (!CharTable.load(HanLP.Config.CharTablePath)) {
            Predefine.logger.severe("\u5b57\u7b26\u6b63\u89c4\u5316\u8868\u52a0\u8f7d\u5931\u8d25");
            System.exit(-1);
        }
        Predefine.logger.info("\u5b57\u7b26\u6b63\u89c4\u5316\u8868\u52a0\u8f7d\u6210\u529f\uff1a" + (System.currentTimeMillis() - start) + " ms");
    }

    private static boolean load(String path) {
        String binPath = String.valueOf(path) + ".bin";
        if (CharTable.loadBin(binPath)) {
            return true;
        }
        CONVERT = new char[65536];
        int i = 0;
        while (i < CONVERT.length) {
            CharTable.CONVERT[i] = (char)i;
            ++i;
        }
        IOUtil.LineIterator iterator = new IOUtil.LineIterator(path);
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line == null) {
                return false;
            }
            if (line.length() != 3) continue;
            CharTable.CONVERT[line.charAt((int)0)] = CONVERT[line.charAt(2)];
        }
        Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u5b57\u7b26\u6b63\u89c4\u5316\u8868\u5230" + binPath);
        IOUtil.saveObjectTo(CONVERT, binPath);
        return true;
    }

    private static boolean loadBin(String path) {
        try {
            ObjectInputStream in = new ObjectInputStream(IOUtil.newInputStream(path));
            CONVERT = (char[])in.readObject();
            in.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5b57\u7b26\u6b63\u89c4\u5316\u8868\u7f13\u5b58\u52a0\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a" + e);
            return false;
        }
        return true;
    }

    public static char convert(char c) {
        return CONVERT[c];
    }

    public static char[] convert(char[] charArray) {
        char[] result = new char[charArray.length];
        int i = 0;
        while (i < charArray.length) {
            result[i] = CONVERT[charArray[i]];
            ++i;
        }
        return result;
    }

    public static String convert(String charArray) {
        assert (charArray != null);
        char[] result = new char[charArray.length()];
        int i = 0;
        while (i < charArray.length()) {
            result[i] = CONVERT[charArray.charAt(i)];
            ++i;
        }
        return new String(result);
    }

    public static void normalization(char[] charArray) {
        assert (charArray != null);
        int i = 0;
        while (i < charArray.length) {
            charArray[i] = CONVERT[charArray[i]];
            ++i;
        }
    }
}

