/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.py;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.dictionary.StringDictionary;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.dictionary.py.Integer2PinyinConverter;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.utility.Predefine;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PinyinDictionary {
    static AhoCorasickDoubleArrayTrie<Pinyin[]> trie = new AhoCorasickDoubleArrayTrie();
    public static final Pinyin[] pinyins = Integer2PinyinConverter.pinyins;

    static {
        long start = System.currentTimeMillis();
        if (!PinyinDictionary.modifyLoad(HanLP.Config.PinyinDictionaryPath)) {
            throw new IllegalArgumentException("\u62fc\u97f3\u8bcd\u5178" + HanLP.Config.PinyinDictionaryPath + "\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info("\u62fc\u97f3\u8bcd\u5178" + HanLP.Config.PinyinDictionaryPath + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    static boolean load(String path) {
        if (PinyinDictionary.loadDat(path)) {
            return true;
        }
        StringDictionary dictionary = new StringDictionary("=");
        if (!dictionary.load(path)) {
            return false;
        }
        TreeMap<String, Pinyin[]> map = new TreeMap<String, Pinyin[]>();
        for (Map.Entry entry : dictionary.entrySet()) {
            String[] args = ((String)entry.getValue()).split(",");
            Pinyin[] pinyinValue = new Pinyin[args.length];
            int i = 0;
            while (i < pinyinValue.length) {
                try {
                    Pinyin pinyin;
                    pinyinValue[i] = pinyin = Pinyin.valueOf(args[i]);
                }
                catch (IllegalArgumentException e) {
                    Predefine.logger.severe("\u8bfb\u53d6\u62fc\u97f3\u8bcd\u5178" + path + "\u5931\u8d25\uff0c\u95ee\u9898\u51fa\u5728\u3010" + entry + "\u3011\uff0c\u5f02\u5e38\u662f" + e);
                    return false;
                }
                ++i;
            }
            map.put(entry.getKey(), pinyinValue);
        }
        trie.build(map);
        Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u53cc\u6570\u7ec4" + path);
        PinyinDictionary.saveDat(path, trie, map.entrySet());
        return true;
    }

    static boolean loadDat(String path) {
        ByteArray byteArray = ByteArray.createByteArray(String.valueOf(path) + ".bin");
        if (byteArray == null) {
            return false;
        }
        int size = byteArray.nextInt();
        Pinyin[][] valueArray = new Pinyin[size][];
        int i = 0;
        while (i < valueArray.length) {
            int length = byteArray.nextInt();
            valueArray[i] = new Pinyin[length];
            int j = 0;
            while (j < length) {
                valueArray[i][j] = pinyins[byteArray.nextInt()];
                ++j;
            }
            ++i;
        }
        return trie.load(byteArray, (V[])valueArray);
    }

    static boolean saveDat(String path, AhoCorasickDoubleArrayTrie<Pinyin[]> trie, Set<Map.Entry<String, Pinyin[]>> entrySet) {
        try {
            DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(String.valueOf(path) + ".bin"));
            out.writeInt(entrySet.size());
            for (Map.Entry<String, Pinyin[]> entry : entrySet) {
                Pinyin[] value = entry.getValue();
                out.writeInt(value.length);
                Pinyin[] pinyinArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    Pinyin pinyin = pinyinArray[n2];
                    out.writeInt(pinyin.ordinal());
                    ++n2;
                }
            }
            trie.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u7f13\u5b58\u503cdat" + path + "\u5931\u8d25");
            return false;
        }
        return true;
    }

    public static Pinyin[] get(String key) {
        return trie.get(key);
    }

    public static List<Pinyin> convertToPinyin(String text) {
        return PinyinDictionary.segLongest(text.toCharArray(), trie);
    }

    public static List<Pinyin> convertToPinyin(String text, boolean remainNone) {
        return PinyinDictionary.segLongest(text.toCharArray(), trie, remainNone);
    }

    public static Pinyin[] convertToPinyinArray(String text) {
        return PinyinDictionary.convertToPinyin(text).toArray(new Pinyin[0]);
    }

    public static BaseSearcher getSearcher(char[] charArray, DoubleArrayTrie<Pinyin[]> trie) {
        return new Searcher(charArray, trie);
    }

    protected static List<Pinyin> segLongest(char[] charArray, AhoCorasickDoubleArrayTrie<Pinyin[]> trie) {
        return PinyinDictionary.segLongest(charArray, trie, true);
    }

    protected static List<Pinyin> segLongest(char[] charArray, AhoCorasickDoubleArrayTrie<Pinyin[]> trie, boolean remainNone) {
        final Pinyin[][] wordNet = new Pinyin[charArray.length][];
        trie.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<Pinyin[]>(){

            @Override
            public void hit(int begin, int end, Pinyin[] value) {
                int length = end - begin;
                if (wordNet[begin] == null || length > wordNet[begin].length) {
                    Pinyin[] pinyinArray;
                    if (length == 1) {
                        Pinyin[] pinyinArray2 = new Pinyin[1];
                        pinyinArray = pinyinArray2;
                        pinyinArray2[0] = value[0];
                    } else {
                        pinyinArray = value;
                    }
                    wordNet[begin] = pinyinArray;
                }
            }
        });
        ArrayList<Pinyin> pinyinList = new ArrayList<Pinyin>(charArray.length);
        int offset = 0;
        while (offset < wordNet.length) {
            if (wordNet[offset] == null) {
                if (remainNone) {
                    pinyinList.add(Pinyin.none5);
                }
                ++offset;
                continue;
            }
            Pinyin[] pinyinArray = wordNet[offset];
            int n = pinyinArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pinyin pinyin = pinyinArray[n2];
                pinyinList.add(pinyin);
                ++n2;
            }
            offset += wordNet[offset].length;
        }
        return pinyinList;
    }

    static boolean modifyLoad(String path) {
        StringDictionary dictionary = new StringDictionary("=");
        if (!dictionary.load(path)) {
            return false;
        }
        TreeMap<String, Pinyin[]> map = new TreeMap<String, Pinyin[]>();
        for (Map.Entry entry : dictionary.entrySet()) {
            String[] args = ((String)entry.getValue()).split(",");
            Pinyin[] pinyinValue = new Pinyin[args.length];
            int i = 0;
            while (i < pinyinValue.length) {
                try {
                    Pinyin pinyin;
                    pinyinValue[i] = pinyin = Pinyin.valueOf(args[i]);
                }
                catch (IllegalArgumentException e) {
                    Predefine.logger.severe("\u8bfb\u53d6\u62fc\u97f3\u8bcd\u5178" + path + "\u5931\u8d25\uff0c\u95ee\u9898\u51fa\u5728\u3010" + entry + "\u3011\uff0c\u5f02\u5e38\u662f" + e);
                    return false;
                }
                ++i;
            }
            map.put(entry.getKey(), pinyinValue);
        }
        trie.build(map);
        Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u53cc\u6570\u7ec4" + path);
        return PinyinDictionary.modifyLoadDat(PinyinDictionary.modifySaveDat(trie, map.entrySet()));
    }

    static byte[] modifySaveDat(AhoCorasickDoubleArrayTrie<Pinyin[]> trie, Set<Map.Entry<String, Pinyin[]>> entrySet) {
        ArrayList<Byte> byteLists = new ArrayList<Byte>();
        int enSetSize = entrySet.size();
        if (enSetSize <= 0) {
            return null;
        }
        byteLists.add((byte)(enSetSize >>> 24));
        byteLists.add((byte)(enSetSize >>> 16));
        byteLists.add((byte)(enSetSize >>> 8));
        byteLists.add((byte)enSetSize);
        for (Map.Entry<String, Pinyin[]> entry : entrySet) {
            Pinyin[] value = entry.getValue();
            int valueLen = value.length;
            byteLists.add((byte)(valueLen >>> 24));
            byteLists.add((byte)(valueLen >>> 16));
            byteLists.add((byte)(valueLen >>> 8));
            byteLists.add((byte)valueLen);
            Pinyin[] pinyinArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                Pinyin pinyin = pinyinArray[n2];
                int temp = pinyin.ordinal();
                byteLists.add((byte)(temp >>> 24));
                byteLists.add((byte)(temp >>> 16));
                byteLists.add((byte)(temp >>> 8));
                byteLists.add((byte)temp);
                ++n2;
            }
        }
        List<Byte> tempbytes = trie.modifySave();
        byteLists.addAll(tempbytes);
        byte[] bytes = new byte[byteLists.size()];
        int i = 0;
        while (i < byteLists.size()) {
            bytes[i] = (Byte)byteLists.get(i);
            ++i;
        }
        return bytes;
    }

    static boolean modifyLoadDat(byte[] bytes) {
        ByteArray byteArray;
        ByteArray byteArray2 = byteArray = bytes == null ? null : new ByteArray(bytes);
        if (byteArray == null) {
            return false;
        }
        int size = byteArray.nextInt();
        Pinyin[][] valueArray = new Pinyin[size][];
        int i = 0;
        while (i < valueArray.length) {
            int length = byteArray.nextInt();
            valueArray[i] = new Pinyin[length];
            int j = 0;
            while (j < length) {
                valueArray[i][j] = pinyins[byteArray.nextInt()];
                ++j;
            }
            ++i;
        }
        return trie.load(byteArray, (V[])valueArray);
    }

    public static class Searcher
    extends BaseSearcher<Pinyin[]> {
        int begin;
        DoubleArrayTrie<Pinyin[]> trie;

        protected Searcher(char[] c, DoubleArrayTrie<Pinyin[]> trie) {
            super(c);
            this.trie = trie;
        }

        protected Searcher(String text, DoubleArrayTrie<Pinyin[]> trie) {
            super(text);
            this.trie = trie;
        }

        @Override
        public Map.Entry<String, Pinyin[]> next() {
            Map.Entry<String, Pinyin[]> result = null;
            while (this.begin < this.c.length) {
                LinkedList<Map.Entry<String, Pinyin[]>> entryList = this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                if (entryList.size() == 0) {
                    ++this.begin;
                    continue;
                }
                result = entryList.getLast();
                this.offset = this.begin;
                this.begin += result.getKey().length();
                break;
            }
            if (result == null) {
                return null;
            }
            return result;
        }
    }
}

