/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.py;

import com.hankcs.hanlp.algorithm.ahocorasick.trie.Token;
import com.hankcs.hanlp.algorithm.ahocorasick.trie.Trie;
import com.hankcs.hanlp.dictionary.py.Integer2PinyinConverter;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.String2PinyinConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TonePinyinString2PinyinConverter {
    static Map<String, Pinyin> mapKey;
    static Map<String, Pinyin> mapNumberKey;
    static Trie trie;

    static {
        mapNumberKey = new TreeMap<String, Pinyin>();
        mapKey = new TreeMap<String, Pinyin>();
        Pinyin[] pinyinArray = Integer2PinyinConverter.pinyins;
        int n = Integer2PinyinConverter.pinyins.length;
        int n2 = 0;
        while (n2 < n) {
            Pinyin pinyin = pinyinArray[n2];
            mapNumberKey.put(pinyin.toString(), pinyin);
            String pinyinWithToneMark = pinyin.getPinyinWithToneMark();
            String pinyinWithoutTone = pinyin.getPinyinWithoutTone();
            Pinyin tone5 = String2PinyinConverter.convert2Tone5(pinyin);
            mapKey.put(pinyinWithToneMark, pinyin);
            mapKey.put(pinyinWithoutTone, tone5);
            ++n2;
        }
        trie = new Trie().remainLongest();
        trie.addAllKeyword(mapKey.keySet());
    }

    public static boolean valid(String singlePinyin) {
        return mapNumberKey.containsKey(singlePinyin);
    }

    public static Pinyin convertFromToneNumber(String singlePinyin) {
        return mapNumberKey.get(singlePinyin);
    }

    public static List<Pinyin> convert(String[] pinyinArray) {
        ArrayList<Pinyin> pinyinList = new ArrayList<Pinyin>(pinyinArray.length);
        int i = 0;
        while (i < pinyinArray.length) {
            pinyinList.add(mapKey.get(pinyinArray[i]));
            ++i;
        }
        return pinyinList;
    }

    public static Pinyin convert(String singlePinyin) {
        return mapKey.get(singlePinyin);
    }

    public static List<Pinyin> convert(String tonePinyinText, boolean removeNull) {
        LinkedList<Pinyin> pinyinList = new LinkedList<Pinyin>();
        Collection<Token> tokenize = trie.tokenize(tonePinyinText);
        for (Token token : tokenize) {
            Pinyin pinyin = mapKey.get(token.getFragment());
            if (removeNull && pinyin == null) continue;
            pinyinList.add(pinyin);
        }
        return pinyinList;
    }

    public static boolean valid(String[] pinyinStringArray) {
        String[] stringArray = pinyinStringArray;
        int n = pinyinStringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!TonePinyinString2PinyinConverter.valid(p)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static List<Pinyin> convertFromToneNumber(String[] pinyinArray) {
        ArrayList<Pinyin> pinyinList = new ArrayList<Pinyin>(pinyinArray.length);
        String[] stringArray = pinyinArray;
        int n = pinyinArray.length;
        int n2 = 0;
        while (n2 < n) {
            String py = stringArray[n2];
            pinyinList.add(TonePinyinString2PinyinConverter.convertFromToneNumber(py));
            ++n2;
        }
        return pinyinList;
    }
}

