/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.stopword;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.stopword.Filter;
import com.hankcs.hanlp.dictionary.stopword.StopWordDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.util.List;
import java.util.ListIterator;

public class CoreStopWordDictionary {
    static StopWordDictionary dictionary;
    public static Filter FILTER;

    static {
        ByteArray byteArray = ByteArray.createByteArray(String.valueOf(HanLP.Config.CoreStopWordDictionaryPath) + ".bin");
        if (byteArray == null) {
            try {
                dictionary = new StopWordDictionary(HanLP.Config.CoreStopWordDictionaryPath);
                DataOutputStream out = new DataOutputStream(IOUtil.newOutputStream(String.valueOf(HanLP.Config.CoreStopWordDictionaryPath) + ".bin"));
                dictionary.save(out);
                out.close();
            }
            catch (Exception e) {
                Predefine.logger.severe("\u8f7d\u5165\u505c\u7528\u8bcd\u8bcd\u5178" + HanLP.Config.CoreStopWordDictionaryPath + "\u5931\u8d25" + TextUtility.exceptionToString(e));
            }
        } else {
            dictionary = new StopWordDictionary();
            dictionary.load(byteArray);
        }
        FILTER = new Filter(){

            @Override
            public boolean shouldInclude(Term term) {
                String nature = term.nature != null ? term.nature.toString() : "\u7a7a";
                char firstChar = nature.charAt(0);
                switch (firstChar) {
                    case 'b': 
                    case 'c': 
                    case 'e': 
                    case 'm': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 'u': 
                    case 'w': 
                    case 'y': 
                    case 'z': {
                        return false;
                    }
                }
                return !CoreStopWordDictionary.contains(term.word);
            }
        };
    }

    public static boolean contains(String key) {
        return dictionary.contains(key);
    }

    public static boolean shouldInclude(Term term) {
        return FILTER.shouldInclude(term);
    }

    public static boolean shouldRemove(Term term) {
        return !CoreStopWordDictionary.shouldInclude(term);
    }

    public static boolean add(String stopWord) {
        return dictionary.add(stopWord);
    }

    public static boolean remove(String stopWord) {
        return dictionary.remove(stopWord);
    }

    public static void apply(List<Term> termList) {
        ListIterator<Term> listIterator = termList.listIterator();
        while (listIterator.hasNext()) {
            if (!CoreStopWordDictionary.shouldRemove(listIterator.next())) continue;
            listIterator.remove();
        }
    }
}

