/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class HongKongToTaiwanChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    static {
        long start = System.currentTimeMillis();
        String datPath = String.valueOf(HanLP.Config.tcDictionaryRoot) + "hk2tw";
        if (!HongKongToTaiwanChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> t2tw = new TreeMap<String, String>();
            TreeMap<String, String> hk2t = new TreeMap<String, String>();
            if (!HongKongToTaiwanChineseDictionary.load(t2tw, false, String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2tw.txt") || !HongKongToTaiwanChineseDictionary.load(hk2t, true, String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2hk.txt")) {
                throw new IllegalArgumentException("\u9999\u6e2f\u7e41\u4f53\u8f6c\u53f0\u6e7e\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            }
            HongKongToTaiwanChineseDictionary.combineReverseChain(t2tw, hk2t, false);
            trie.build(t2tw);
            HongKongToTaiwanChineseDictionary.saveDat(datPath, trie, t2tw.entrySet());
        }
        Predefine.logger.info("\u9999\u6e2f\u7e41\u4f53\u8f6c\u53f0\u6e7e\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    public static String convertToTraditionalTaiwanChinese(String traditionalHongKongChinese) {
        return HongKongToTaiwanChineseDictionary.segLongest(traditionalHongKongChinese.toCharArray(), trie);
    }

    public static String convertToTraditionalTaiwanChinese(char[] traditionalHongKongChinese) {
        return HongKongToTaiwanChineseDictionary.segLongest(traditionalHongKongChinese, trie);
    }
}

