/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class HongKongToTraditionalChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    static {
        long start = System.currentTimeMillis();
        String datPath = String.valueOf(HanLP.Config.tcDictionaryRoot) + "hk2t";
        if (!HongKongToTraditionalChineseDictionary.load(datPath, trie)) {
            TreeMap<String, String> hk2t = new TreeMap<String, String>();
            if (!HongKongToTraditionalChineseDictionary.load(hk2t, true, String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2hk.txt")) {
                throw new IllegalArgumentException("\u9999\u6e2f\u7e41\u4f53\u8f6c\u7e41\u4f53\u52a0\u8f7d\u5931\u8d25");
            }
            trie.build(hk2t);
            HongKongToTraditionalChineseDictionary.saveDat(datPath, trie, hk2t.entrySet());
        }
        Predefine.logger.info("\u9999\u6e2f\u7e41\u4f53\u8f6c\u7e41\u4f53\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    public static String convertToTraditionalChinese(String traditionalHongKongChineseString) {
        return HongKongToTraditionalChineseDictionary.segLongest(traditionalHongKongChineseString.toCharArray(), trie);
    }

    public static String convertToTraditionalChinese(char[] traditionalHongKongChineseString) {
        return HongKongToTraditionalChineseDictionary.segLongest(traditionalHongKongChineseString, trie);
    }
}

