/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;

public class SimplifiedChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    static {
        long start = System.currentTimeMillis();
        if (!SimplifiedChineseDictionary.load(String.valueOf(HanLP.Config.tcDictionaryRoot) + "s2t.txt", trie, false)) {
            throw new IllegalArgumentException("\u7b80\u7e41\u8bcd\u5178" + HanLP.Config.tcDictionaryRoot + "s2t.txt" + ".bin" + "\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info("\u7b80\u7e41\u8bcd\u5178" + HanLP.Config.tcDictionaryRoot + "s2t.txt" + ".bin" + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    public static String convertToTraditionalChinese(String simplifiedChineseString) {
        return SimplifiedChineseDictionary.segLongest(simplifiedChineseString.toCharArray(), trie);
    }

    public static String convertToTraditionalChinese(char[] simplifiedChinese) {
        return SimplifiedChineseDictionary.segLongest(simplifiedChinese, trie);
    }

    public static String getTraditionalChinese(String simplifiedChinese) {
        return trie.get(simplifiedChinese);
    }
}

