/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class TaiwanToSimplifiedChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    static {
        long start = System.currentTimeMillis();
        String datPath = String.valueOf(HanLP.Config.tcDictionaryRoot) + "tw2s";
        if (!TaiwanToSimplifiedChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> t2s = new TreeMap<String, String>();
            TreeMap<String, String> tw2t = new TreeMap<String, String>();
            if (!TaiwanToSimplifiedChineseDictionary.load(t2s, false, String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2s.txt") || !TaiwanToSimplifiedChineseDictionary.load(tw2t, true, String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2tw.txt")) {
                throw new IllegalArgumentException("\u53f0\u6e7e\u7e41\u4f53\u8f6c\u7b80\u4f53\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            }
            TaiwanToSimplifiedChineseDictionary.combineReverseChain(t2s, tw2t, true);
            trie.build(t2s);
            TaiwanToSimplifiedChineseDictionary.saveDat(datPath, trie, t2s.entrySet());
        }
        Predefine.logger.info("\u53f0\u6e7e\u7e41\u4f53\u8f6c\u7b80\u4f53\u8bcd\u5178\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    public static String convertToSimplifiedChinese(String traditionalTaiwanChinese) {
        return TaiwanToSimplifiedChineseDictionary.segLongest(traditionalTaiwanChinese.toCharArray(), trie);
    }

    public static String convertToSimplifiedChinese(char[] traditionalTaiwanChinese) {
        return TaiwanToSimplifiedChineseDictionary.segLongest(traditionalTaiwanChinese, trie);
    }
}

