/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class TraditionalToHongKongChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    static {
        long start = System.currentTimeMillis();
        String datPath = String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2hk";
        if (!TraditionalToHongKongChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> t2hk = new TreeMap<String, String>();
            if (!TraditionalToHongKongChineseDictionary.load(t2hk, false, String.valueOf(HanLP.Config.tcDictionaryRoot) + "t2hk.txt")) {
                throw new IllegalArgumentException("\u7e41\u4f53\u8f6c\u9999\u6e2f\u7e41\u4f53\u52a0\u8f7d\u5931\u8d25");
            }
            trie.build(t2hk);
            TraditionalToHongKongChineseDictionary.saveDat(datPath, trie, t2hk.entrySet());
        }
        Predefine.logger.info("\u7e41\u4f53\u8f6c\u9999\u6e2f\u7e41\u4f53\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }

    public static String convertToHongKongTraditionalChinese(String traditionalChineseString) {
        return TraditionalToHongKongChineseDictionary.segLongest(traditionalChineseString.toCharArray(), trie);
    }

    public static String convertToHongKongTraditionalChinese(char[] traditionalHongKongChineseString) {
        return TraditionalToHongKongChineseDictionary.segLongest(traditionalHongKongChineseString, trie);
    }
}

