/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.VectorsReader;
import java.io.IOException;
import java.util.Scanner;

public abstract class AbstractClosestVectors {
    static final int N = 40;
    protected Scanner scanner;
    protected final VectorsReader vectorsReader;

    protected AbstractClosestVectors(String file) {
        this.vectorsReader = new VectorsReader(file);
    }

    protected String[] nextWords(int n, String msg) {
        System.out.println(String.valueOf(msg) + " ('q' to break): ");
        String[] words = new String[n];
        int i = 0;
        while (i < n) {
            String word = this.nextWord();
            if (word == null) {
                return null;
            }
            words[i] = word;
            ++i;
        }
        return words;
    }

    protected String nextWord() {
        String word = this.scanner.next();
        return word == null || word.length() == 0 || word.equals("q") ? null : word;
    }

    protected abstract Result getTargetVector();

    protected final void execute() throws IOException {
        this.vectorsReader.readVectorFile();
        int words = this.vectorsReader.getNumWords();
        int size = this.vectorsReader.getSize();
        try {
            this.scanner = new Scanner(System.in);
            Result result = null;
            while ((result = this.getTargetVector()) != null) {
                double[] bestd = new double[40];
                String[] bestw = new String[40];
                int i = 0;
                while (i < words) {
                    block12: {
                        int[] nArray = result.bi;
                        int n = result.bi.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int bi = nArray[n2];
                            if (i != bi) {
                                ++n2;
                                continue;
                            }
                            break block12;
                        }
                        double dist = 0.0;
                        int j = 0;
                        while (j < size) {
                            dist += (double)(result.vec[j] * this.vectorsReader.getMatrixElement(i, j));
                            ++j;
                        }
                        j = 0;
                        while (j < 40) {
                            if (dist > bestd[j]) {
                                int k = 39;
                                while (k > j) {
                                    bestd[k] = bestd[k - 1];
                                    bestw[k] = bestw[k - 1];
                                    --k;
                                }
                                bestd[j] = dist;
                                bestw[j] = this.vectorsReader.getWord(i);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                System.out.printf("\n                                              Word       Cosine cosine\n------------------------------------------------------------------------\n", new Object[0]);
                int j = 0;
                while (j < 40) {
                    System.out.printf("%50s\t\t%f\n", bestw[j], bestd[j]);
                    ++j;
                }
            }
        }
        finally {
            this.scanner.close();
        }
    }

    protected static class Result {
        float[] vec;
        int[] bi;

        public Result(float[] vec, int[] bi) {
            this.vec = vec;
            this.bi = bi;
        }
    }
}

