/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.Config;

public abstract class AbstractTrainer {
    protected abstract void localUsage();

    protected void paramDesc(String param, String desc) {
        System.err.printf("\t%s\n\t\t%s\n", param, desc);
    }

    protected void usage() {
        System.err.printf("word2vec Java toolkit v 0.1c\n\n", new Object[0]);
        System.err.printf("Options:\n", new Object[0]);
        System.err.printf("Parameters for training:\n", new Object[0]);
        this.paramDesc("-output <file>", "Use <file> to save the resulting word vectors / word clusters");
        this.paramDesc("-size <int>", "Set size of word vectors; default is 100");
        this.paramDesc("-window <int>", "Set max skip length between words; default is 5");
        this.paramDesc("-sample <float>", "Set threshold for occurrence of words. Those that appear with higher frequency in the training data will be randomly down-sampled; default is 0.001, useful range is (0, 0.00001)");
        this.paramDesc("-hs", "Use Hierarchical Softmax; default is not used");
        this.paramDesc("-negative <int>", "Number of negative examples; default is 5, common values are 3 - 10 (0 = not used)");
        this.paramDesc("-threads <int>", "Use <int> threads (default is the cores of local machine)");
        this.paramDesc("-iter <int>", "Run more training iterations (default 5)");
        this.paramDesc("-min-count <int>", "This will discard words that appear less than <int> times; default is 5");
        this.paramDesc("-alpha <float>", "Set the starting learning rate; default is 0.025 for skip-gram and 0.05 for CBOW");
        this.paramDesc("-cbow", "Use the continuous bag of words model; default is skip-gram model");
        this.localUsage();
        System.exit(0);
    }

    protected int argPos(String param, String[] args) {
        return this.argPos(param, args, true);
    }

    protected int argPos(String param, String[] args, boolean checkArgNum) {
        int i = 0;
        while (i < args.length) {
            if (param.equals(args[i])) {
                if (checkArgNum && i == args.length - 1) {
                    throw new IllegalArgumentException(String.format("Argument missing for %s", param));
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setConfig(String[] args, Config config) {
        int i = this.argPos("-size", args);
        if (i >= 0) {
            config.setLayer1Size(Integer.parseInt(args[i + 1]));
        }
        if ((i = this.argPos("-output", args)) >= 0) {
            config.setOutputFile(args[i + 1]);
        }
        if ((i = this.argPos("-cbow", args)) >= 0) {
            config.setUseContinuousBagOfWords(true);
        }
        if (config.useContinuousBagOfWords()) {
            config.setAlpha(0.05f);
        }
        if ((i = this.argPos("-alpha", args)) >= 0) {
            config.setAlpha(Float.parseFloat(args[i + 1]));
        }
        if ((i = this.argPos("-window", args)) >= 0) {
            config.setWindow(Integer.parseInt(args[i + 1]));
        }
        if ((i = this.argPos("-sample", args)) >= 0) {
            config.setSample(Float.parseFloat(args[i + 1]));
        }
        if ((i = this.argPos("-hs", args)) >= 0) {
            config.setUseHierarchicalSoftmax(true);
        }
        if ((i = this.argPos("-negative", args)) >= 0) {
            config.setNegative(Integer.parseInt(args[i + 1]));
        }
        if ((i = this.argPos("-threads", args)) >= 0) {
            config.setNumThreads(Integer.parseInt(args[i + 1]));
        }
        if ((i = this.argPos("-iter", args)) >= 0) {
            config.setIter(Integer.parseInt(args[i + 1]));
        }
        if ((i = this.argPos("-min-count", args)) >= 0) {
            config.setMinCount(Integer.parseInt(args[i + 1]));
        }
    }
}

