/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ComputeAccuracy {
    static final int max_size = 2000;
    static final int N = 1;
    static final int max_w = 50;

    public static void main(String[] argv) throws IOException {
        int a;
        int b;
        double[] M;
        String[] vocab;
        BufferedReader f;
        String st1 = null;
        String[] bestw = new String[1];
        double[] bestd = new double[1];
        double[] vec = new double[2000];
        int words = 0;
        int size = 0;
        int threshold = 0;
        int CCN = 0;
        int TACN = 0;
        int CACN = 0;
        int SECN = 0;
        int SYCN = 0;
        int SEAC = 0;
        int SYAC = 0;
        int QID = 0;
        int TQ = 0;
        int TQS = 0;
        if (argv == null || argv.length != 3) {
            ComputeAccuracy.printf("Usage: ./compute-accuracy <FILE> <threshold> <QUESTION FILE>\nwhere FILE contains word projections, and threshold is used to reduce vocabulary of the model for fast approximate evaluation (0 = off, otherwise typical value is 30000). Question file contains questions and answers\n", new Object[0]);
            return;
        }
        String file_name = argv[0];
        threshold = Integer.parseInt(argv[1]);
        try {
            f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file_name), "UTF-8"));
        }
        catch (FileNotFoundException e) {
            ComputeAccuracy.printf("Input file not found\n", new Object[0]);
            System.exit(-1);
            return;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        try {
            String[] params = f.readLine().split("\\s");
            words = Integer.parseInt(params[0]);
            if (words > threshold) {
                words = threshold;
            }
            size = Integer.parseInt(params[1]);
            vocab = new String[words];
            M = new double[words * size];
            b = 0;
            while (b < words) {
                params = f.readLine().split("\\s");
                vocab[b] = params[0].toUpperCase();
                a = 0;
                while (a < size) {
                    M[a + b * size] = Double.parseDouble(params[1 + a]);
                    ++a;
                }
                double len = 0.0;
                a = 0;
                while (a < size) {
                    len += M[a + b * size] * M[a + b * size];
                    ++a;
                }
                len = Math.sqrt(len);
                a = 0;
                while (a < size) {
                    int n = a + b * size;
                    M[n] = M[n] / len;
                    ++a;
                }
                ++b;
            }
            f.close();
        }
        catch (IOException e) {
            ComputeAccuracy.printf("IO error\n", new Object[0]);
            System.exit(-2);
            return;
        }
        catch (OutOfMemoryError e) {
            ComputeAccuracy.printf("Cannot allocate memory: %lld MB\n", words * size * 8 / 0x100000);
            System.exit(-3);
            return;
        }
        int TCN = 0;
        BufferedReader stdin = null;
        try {
            stdin = new BufferedReader(new InputStreamReader(new FileInputStream(argv[2])));
        }
        catch (FileNotFoundException e) {
            ComputeAccuracy.printf("Question file %s not found\n", argv[2]);
        }
        while (true) {
            a = 0;
            while (a < 1) {
                bestd[a] = 0.0;
                ++a;
            }
            a = 0;
            while (a < 1) {
                bestw[a] = null;
                ++a;
            }
            String line = stdin.readLine();
            String[] params = null;
            if (line != null && line.length() > 0) {
                params = line.toUpperCase().split("\\s");
                st1 = params[0];
            }
            if (line == null || line.length() == 0 || st1.equals(":") || st1.equals("EXIT")) {
                if (TCN == 0) {
                    TCN = 1;
                }
                if (QID != 0) {
                    ComputeAccuracy.printf("ACCURACY TOP1: %.2f %%  (%d / %d)\n", (double)CCN / (double)TCN * 100.0, CCN, TCN);
                    ComputeAccuracy.printf("Total accuracy: %.2f %%   Semantic accuracy: %.2f %%   Syntactic accuracy: %.2f %% \n", (double)CACN / (double)TACN * 100.0, (double)SEAC / (double)SECN * 100.0, (double)SYAC / (double)SYCN * 100.0);
                }
                ++QID;
                if (line == null || line.length() == 0) break;
                st1 = params[1];
                ComputeAccuracy.printf("%s:\n", st1);
                TCN = 0;
                CCN = 0;
                continue;
            }
            if ("EXIT".equals(st1)) break;
            String st2 = params[1];
            String st3 = params[2];
            String st4 = params[3];
            b = 0;
            while (b < words) {
                if (st1.equals(vocab[b])) break;
                ++b;
            }
            int b1 = b;
            b = 0;
            while (b < words) {
                if (st2.equals(vocab[b])) break;
                ++b;
            }
            int b2 = b;
            b = 0;
            while (b < words) {
                if (st3.equals(vocab[b])) break;
                ++b;
            }
            int b3 = b;
            a = 0;
            while (a < 1) {
                bestd[a] = 0.0;
                ++a;
            }
            a = 0;
            while (a < 1) {
                bestw[a] = null;
                ++a;
            }
            ++TQ;
            if (b1 == words || b2 == words || b3 == words) continue;
            b = 0;
            while (b < words) {
                if (st4.equals(vocab[b])) break;
                ++b;
            }
            if (b == words) continue;
            a = 0;
            while (a < size) {
                vec[a] = M[a + b2 * size] - M[a + b1 * size] + M[a + b3 * size];
                ++a;
            }
            ++TQS;
            int c = 0;
            while (c < words) {
                if (c != b1 && c != b2 && c != b3) {
                    double dist = 0.0;
                    a = 0;
                    while (a < size) {
                        dist += vec[a] * M[a + c * size];
                        ++a;
                    }
                    a = 0;
                    while (a < 1) {
                        if (dist > bestd[a]) {
                            int d = 0;
                            while (d > a) {
                                bestd[d] = bestd[d - 1];
                                bestw[d] = bestw[d - 1];
                                --d;
                            }
                            bestd[a] = dist;
                            bestw[a] = vocab[c];
                            break;
                        }
                        ++a;
                    }
                }
                ++c;
            }
            if (st4.equals(bestw[0])) {
                ++CCN;
                ++CACN;
                if (QID <= 5) {
                    ++SEAC;
                } else {
                    ++SYAC;
                }
            }
            if (QID <= 5) {
                ++SECN;
            } else {
                ++SYCN;
            }
            ++TCN;
            ++TACN;
        }
        ComputeAccuracy.printf("Questions seen / total: %d %d   %.2f %% \n", TQS, TQ, (double)TQS / (double)TQ * 100.0);
    }

    private static void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }
}

