/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.AbstractClosestVectors;
import java.io.IOException;

public class Distance
extends AbstractClosestVectors {
    public Distance(String file) {
        super(file);
    }

    static void usage() {
        System.err.printf("Usage: java %s <FILE>\nwhere FILE contains word projections in the text format\n", Distance.class.getName());
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            Distance.usage();
        }
        new Distance(args[0]).execute();
    }

    @Override
    protected AbstractClosestVectors.Result getTargetVector() {
        int words = this.vectorsReader.getNumWords();
        int size = this.vectorsReader.getSize();
        String[] input = null;
        while ((input = this.nextWords(1, "Enter a word")) != null) {
            float[] vec = null;
            int bi = -1;
            double len = 0.0;
            int i = 0;
            while (i < words) {
                if (input[0].equals(this.vectorsReader.getWord(i))) {
                    bi = i;
                    System.out.printf("\nWord: %s  Position in vocabulary: %d\n", input[0], bi);
                    vec = new float[size];
                    int j = 0;
                    while (j < size) {
                        vec[j] = this.vectorsReader.getMatrixElement(bi, j);
                        len += (double)(vec[j] * vec[j]);
                        ++j;
                    }
                }
                ++i;
            }
            if (vec == null) {
                System.out.printf("%s : Out of dictionary word!\n", input[0]);
                continue;
            }
            len = Math.sqrt(len);
            i = 0;
            while (i < size) {
                int n = i++;
                vec[n] = (float)((double)vec[n] / len);
            }
            return new AbstractClosestVectors.Result(vec, new int[]{bi});
        }
        return null;
    }
}

