/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.Utils;
import com.hankcs.hanlp.mining.word2vec.VectorsReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public final class KMeansClustering {
    static final Charset ENCODING = Charset.forName("UTF-8");
    private final VectorsReader reader;
    private final int clcn;
    private final String outFile;

    public KMeansClustering(VectorsReader reader, int k, String outFile) {
        this.reader = reader;
        this.clcn = k;
        this.outFile = outFile;
    }

    public void clustering() throws IOException {
        int vocabSize = this.reader.getNumWords();
        int layer1Size = this.reader.getSize();
        FileOutputStream os = null;
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        try {
            os = new FileOutputStream(this.outFile);
            w = new OutputStreamWriter((OutputStream)os, ENCODING);
            pw = new PrintWriter(w);
            System.err.printf("now computing K-means clustering (K=%d)\n", this.clcn);
            int MAX_ITER = 10;
            int[] centcn = new int[this.clcn];
            int[] cl = new int[vocabSize];
            int centSize = this.clcn * layer1Size;
            double[] cent = new double[centSize];
            int i = 0;
            while (i < vocabSize) {
                cl[i] = i % this.clcn;
                ++i;
            }
            int it = 0;
            while (it < 10) {
                int j = 0;
                while (j < centSize) {
                    cent[j] = 0.0;
                    ++j;
                }
                j = 0;
                while (j < this.clcn) {
                    centcn[j] = 1;
                    ++j;
                }
                int k = 0;
                while (k < vocabSize) {
                    int l = 0;
                    while (l < layer1Size) {
                        int n = layer1Size * cl[k] + l;
                        cent[n] = cent[n] + (double)this.reader.getMatrixElement(k, l);
                        ++l;
                    }
                    int n = cl[k];
                    centcn[n] = centcn[n] + 1;
                    ++k;
                }
                j = 0;
                while (j < this.clcn) {
                    double closev = 0.0;
                    int k2 = 0;
                    while (k2 < layer1Size) {
                        int n = layer1Size * j + k2;
                        cent[n] = cent[n] / (double)centcn[j];
                        closev += cent[layer1Size * j + k2] * cent[layer1Size * j + k2];
                        ++k2;
                    }
                    closev = Math.sqrt(closev);
                    k2 = 0;
                    while (k2 < layer1Size) {
                        int n = layer1Size * j + k2;
                        cent[n] = cent[n] / closev;
                        ++k2;
                    }
                    ++j;
                }
                k = 0;
                while (k < vocabSize) {
                    double closev = -10.0;
                    int closeid = 0;
                    int l = 0;
                    while (l < this.clcn) {
                        double x = 0.0;
                        int j2 = 0;
                        while (j2 < layer1Size) {
                            x += cent[layer1Size * l + j2] * (double)this.reader.getMatrixElement(k, j2);
                            ++j2;
                        }
                        if (x > closev) {
                            closev = x;
                            closeid = l;
                        }
                        ++l;
                    }
                    cl[k] = closeid;
                    ++k;
                }
                ++it;
            }
            System.err.printf("now saving the result of K-means clustering to the file %s\n", this.outFile);
            List[] cluster = new List[this.clcn];
            int i2 = 0;
            while (i2 < cluster.length) {
                cluster[i2] = new LinkedList();
                ++i2;
            }
            i2 = 0;
            while (i2 < vocabSize) {
                cluster[cl[i2]].add(this.reader.getWord(i2));
                ++i2;
            }
            i2 = 0;
            while (i2 < cluster.length) {
                for (String word : cluster[i2]) {
                    pw.printf("%s\t%d\n", word, i2);
                }
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(pw);
            Utils.closeQuietly(w);
            Utils.closeQuietly(os);
            throw throwable;
        }
        Utils.closeQuietly(pw);
        Utils.closeQuietly(w);
        Utils.closeQuietly(os);
    }
}

