/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.AbstractTrainer;
import com.hankcs.hanlp.mining.word2vec.Config;
import com.hankcs.hanlp.mining.word2vec.Word2VecTraining;
import java.io.IOException;

public class Train
extends AbstractTrainer {
    @Override
    protected void localUsage() {
        this.paramDesc("-input <file>", "Use text data from <file> to train the model");
        System.err.printf("\nExamples:\n", new Object[0]);
        System.err.printf("java %s -input corpus.txt -output vectors.txt -size 200 -window 5 -sample 0.0001 -negative 5 -hs 0 -binary -cbow -iter 3\n\n", Train.class.getName());
    }

    void execute(String[] args) throws IOException {
        if (args.length <= 1) {
            this.usage();
        }
        Config config = new Config();
        this.setConfig(args, config);
        int i = this.argPos("-input", args);
        if (i >= 0) {
            config.setInputFile(args[i + 1]);
        }
        Word2VecTraining w2v = new Word2VecTraining(config);
        System.err.printf("Starting training using text file %s\nthreads = %d, iter = %d\n", config.getInputFile(), config.getNumThreads(), config.getIter());
        w2v.trainModel();
    }

    public static void main(String[] args) throws IOException {
        new Train().execute(args);
    }
}

