/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.Utils;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public final class VectorsReader {
    public final Charset ENCODING = Charset.forName("UTF-8");
    int words;
    int size;
    String[] vocab;
    float[][] matrix;
    final String file;

    public VectorsReader(String file) {
        this.file = file;
    }

    public void readVectorFile() throws IOException {
        Predefine.logger.info(String.format("reading %s file. please wait...\n", this.file));
        FileInputStream is = null;
        InputStreamReader r = null;
        BufferedReader br = null;
        try {
            is = new FileInputStream(this.file);
            r = new InputStreamReader((InputStream)is, this.ENCODING);
            br = new BufferedReader(r);
            String line = br.readLine();
            this.words = Integer.parseInt(line.split("\\s+")[0].trim());
            this.size = Integer.parseInt(line.split("\\s+")[1].trim());
            this.vocab = new String[this.words];
            this.matrix = new float[this.words][];
            int i = 0;
            while (i < this.words) {
                line = br.readLine().trim();
                String[] params = line.split("\\s+");
                this.vocab[i] = params[0];
                this.matrix[i] = new float[this.size];
                double len = 0.0;
                int j = 0;
                while (j < this.size) {
                    this.matrix[i][j] = Float.parseFloat(params[j + 1]);
                    len += (double)(this.matrix[i][j] * this.matrix[i][j]);
                    ++j;
                }
                len = Math.sqrt(len);
                j = 0;
                while (j < this.size) {
                    float[] fArray = this.matrix[i];
                    int n = j++;
                    fArray[n] = (float)((double)fArray[n] / len);
                }
                ++i;
            }
        }
        catch (IOException e) {
            Utils.closeQuietly(br);
            Utils.closeQuietly(r);
            Utils.closeQuietly(is);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getNumWords() {
        return this.words;
    }

    public String getWord(int idx) {
        return this.vocab[idx];
    }

    public float getMatrixElement(int row, int column) {
        return this.matrix[row][column];
    }
}

