/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.CacheCorpus;
import com.hankcs.hanlp.mining.word2vec.Config;
import com.hankcs.hanlp.mining.word2vec.Corpus;
import com.hankcs.hanlp.mining.word2vec.TextFileCorpus;
import com.hankcs.hanlp.mining.word2vec.Utils;
import com.hankcs.hanlp.mining.word2vec.VocabWord;
import com.hankcs.hanlp.utility.Predefine;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Comparator;

class Word2VecTraining {
    static final int EXP_TABLE_SIZE = 1000;
    static final int MAX_EXP = 6;
    static final int TABLE_SIZE = 100000000;
    static final int MAX_SENTENCE_LENGTH = 1000;
    static final Charset ENCODING = Charset.forName("UTF-8");
    long timeStart;
    static double[] syn0;
    static double[] syn1;
    static double[] syn1neg;
    int[] table;
    private final Config config;
    static final double[] expTable;
    int threadCount;

    static {
        expTable = new double[1001];
        int i = 0;
        while (i < 1000) {
            Word2VecTraining.expTable[i] = Math.exp(((double)i / 1000.0 * 2.0 - 1.0) * 6.0);
            Word2VecTraining.expTable[i] = expTable[i] / (expTable[i] + 1.0);
            ++i;
        }
    }

    public Word2VecTraining(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void trainModel() throws IOException {
        VocabWord[] vocab;
        int vocabSize;
        TextFileCorpus corpus;
        int layer1Size;
        block16: {
            layer1Size = this.config.getLayer1Size();
            corpus = new TextFileCorpus(this.config);
            Predefine.logger.info("learning vocabulary");
            corpus.learnVocab();
            Predefine.logger.info("sorting vocabulary");
            corpus.sortVocab();
            vocabSize = corpus.getVocabSize();
            vocab = corpus.getVocab();
            Predefine.logger.info("Vocab size: " + vocabSize);
            Predefine.logger.info("Words in train file: " + corpus.getTrainWords());
            if (this.config.getOutputFile() == null) {
                return;
            }
            this.initNet(corpus);
            if (this.config.getNegative() > 0) {
                this.initUnigramTable(corpus);
            }
            this.timeStart = System.currentTimeMillis();
            this.threadCount = this.config.getNumThreads();
            int i23332 = 0;
            while (i23332 < this.config.getNumThreads()) {
                new TrainModelThread(this, new CacheCorpus(corpus), this.config, i23332).start();
                ++i23332;
            }
            corpus.shutdown();
            Word2VecTraining i23332 = this;
            synchronized (i23332) {
                while (true) {
                    while (true) {
                        if (this.threadCount <= 0) {
                            break block16;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        System.err.println();
        Predefine.logger.info(String.format("finished training in %s", Utils.humanTime(System.currentTimeMillis() - this.timeStart)));
        syn1 = null;
        this.table = null;
        FileOutputStream os = null;
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        try {
            os = new FileOutputStream(this.config.getOutputFile());
            w = new OutputStreamWriter((OutputStream)os, ENCODING);
            pw = new PrintWriter(w);
            Predefine.logger.info("now saving the word vectors to the file " + this.config.getOutputFile());
            pw.printf("%d %d\n", vocabSize, layer1Size);
            int i = 0;
            block10: while (i < vocabSize) {
                pw.print(vocab[i].word);
                int j = 0;
                while (true) {
                    if (j >= layer1Size) {
                        pw.println();
                        ++i;
                        continue block10;
                    }
                    pw.printf(" %f", syn0[i * layer1Size + j]);
                    ++j;
                }
            }
        }
        catch (Throwable throwable) {
            corpus.close();
            Utils.closeQuietly(pw);
            Utils.closeQuietly(w);
            Utils.closeQuietly(os);
            throw throwable;
        }
        corpus.close();
        Utils.closeQuietly(pw);
        Utils.closeQuietly(w);
        Utils.closeQuietly(os);
    }

    void initUnigramTable(Corpus corpus) {
        int vocabSize = corpus.getVocabSize();
        VocabWord[] vocab = corpus.getVocab();
        long trainWordsPow = 0L;
        double power = 0.75;
        this.table = new int[100000000];
        int i = 0;
        while (i < vocabSize) {
            trainWordsPow = (long)((double)trainWordsPow + Math.pow(vocab[i].cn, power));
            ++i;
        }
        i = 0;
        double d1 = Math.pow(vocab[i].cn, power) / (double)trainWordsPow;
        int j = 0;
        while (j < 100000000) {
            this.table[j] = i++;
            if ((double)j / 1.0E8 > d1) {
                d1 += Math.pow(vocab[i].cn, power) / (double)trainWordsPow;
            }
            if (i >= vocabSize) {
                i = vocabSize - 1;
            }
            ++j;
        }
    }

    void initNet(Corpus corpus) {
        int j;
        int i;
        int layer1Size = this.config.getLayer1Size();
        int vocabSize = corpus.getVocabSize();
        syn0 = Word2VecTraining.posixMemAlign128(vocabSize * layer1Size);
        if (this.config.useHierarchicalSoftmax()) {
            syn1 = Word2VecTraining.posixMemAlign128(vocabSize * layer1Size);
            i = 0;
            while (i < vocabSize) {
                j = 0;
                while (j < layer1Size) {
                    Word2VecTraining.syn1[i * layer1Size + j] = 0.0;
                    ++j;
                }
                ++i;
            }
        }
        if (this.config.getNegative() > 0) {
            syn1neg = Word2VecTraining.posixMemAlign128(vocabSize * layer1Size);
            i = 0;
            while (i < vocabSize) {
                j = 0;
                while (j < layer1Size) {
                    Word2VecTraining.syn1neg[i * layer1Size + j] = 0.0;
                    ++j;
                }
                ++i;
            }
        }
        long nextRandom = 1L;
        int i2 = 0;
        while (i2 < vocabSize) {
            int j2 = 0;
            while (j2 < layer1Size) {
                nextRandom = Word2VecTraining.nextRandom(nextRandom);
                Word2VecTraining.syn0[i2 * layer1Size + j2] = ((double)(nextRandom & 0xFFFFL) / 65536.0 - 0.5) / (double)layer1Size;
                ++j2;
            }
            ++i2;
        }
        corpus.createBinaryTree();
    }

    static double[] posixMemAlign128(int size) {
        int surplus = size % 128;
        if (surplus > 0) {
            int div = size / 128;
            return new double[(div + 1) * 128];
        }
        return new double[size];
    }

    static long nextRandom(long nextRandom) {
        return nextRandom * 25214903917L + 11L;
    }

    static class TrainModelThread
    extends Thread {
        final Word2VecTraining vec;
        final Corpus corpus;
        final Config config;
        float alpha;
        final float startingAlpha;
        final float trainWords;
        final int id;
        final int vocabSize;
        final long timeStart;
        final int[] table;
        final VocabWord[] vocab;
        static int wordCountActual = 0;

        public TrainModelThread(Word2VecTraining vec, Corpus corpus, Config config, int id) {
            this.vec = vec;
            this.corpus = corpus;
            this.config = config;
            this.startingAlpha = this.alpha = config.getAlpha();
            this.id = id;
            this.table = vec.table;
            this.trainWords = corpus.getTrainWords();
            this.timeStart = vec.timeStart;
            this.vocabSize = corpus.getVocabSize();
            this.vocab = corpus.getVocab();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            float iter = this.config.getIter();
            int layer1Size = this.config.getLayer1Size();
            int numThreads = this.config.getNumThreads();
            int window = this.config.getWindow();
            int negative = this.config.getNegative();
            boolean cbow = this.config.useContinuousBagOfWords();
            boolean hs = this.config.useHierarchicalSoftmax();
            float sample = this.config.getSample();
            try {
                int word = 0;
                int sentence_length = 0;
                int sentence_position = 0;
                int[] sen = new int[1001];
                long word_count = 0L;
                long last_word_count = 0L;
                long local_iter = (int)iter;
                long next_random = this.id;
                double[] neu1 = new double[layer1Size];
                double[] neu1e = new double[layer1Size];
                this.corpus.rewind(numThreads, this.id);
                while (true) {
                    block57: {
                        long label;
                        int target;
                        double g;
                        int l2;
                        double f;
                        int d;
                        int last_word;
                        int a;
                        int b;
                        int c;
                        block56: {
                            block58: {
                                if (word_count - last_word_count > 10000L) {
                                    wordCountActual = (int)((long)wordCountActual + (word_count - last_word_count));
                                    last_word_count = word_count;
                                    long timeNow = System.currentTimeMillis();
                                    float percent = (float)wordCountActual / (iter * this.trainWords + 1.0f);
                                    long cost_time = timeNow - this.timeStart + 1L;
                                    if (this.config.getCallback() == null) {
                                        System.err.printf("%cAlpha: %f  iter: %d  Progress: %.2f%%  Words/thread/sec: %.2fk", 13, Float.valueOf(this.alpha), local_iter, Float.valueOf(percent * 100.0f), Float.valueOf((float)wordCountActual / (float)cost_time));
                                        String etd = Utils.humanTime((long)((float)cost_time / percent * (1.0f - percent)));
                                        if (etd.length() > 0) {
                                            System.err.printf("  ETD: %s", etd);
                                        }
                                        System.err.flush();
                                    } else {
                                        this.config.getCallback().training(this.alpha, percent * 100.0f);
                                    }
                                    this.alpha = this.startingAlpha * (1.0f - (float)wordCountActual / (iter * this.trainWords + 1.0f));
                                    if ((double)this.alpha < (double)this.startingAlpha * 1.0E-4) {
                                        this.alpha = this.startingAlpha * 1.0E-4f;
                                    }
                                }
                                if (sentence_length == 0) {
                                    while ((word = this.corpus.readWordIndex()) != -2) {
                                        double ran;
                                        if (word == -1) continue;
                                        ++word_count;
                                        if (word == -3) break;
                                        if (sample > 0.0f && (ran = (Math.sqrt((float)this.vocab[word].cn / (sample * this.trainWords)) + 1.0) * (double)(sample * this.trainWords) / (double)this.vocab[word].cn) < (double)((next_random = Word2VecTraining.nextRandom(next_random)) & 0xFFFFL) / 65536.0) continue;
                                        sen[sentence_length] = word;
                                        if (++sentence_length < 1000) continue;
                                    }
                                    sentence_position = 0;
                                }
                                if (word == -2 || (float)word_count > this.trainWords / (float)numThreads) {
                                    wordCountActual = (int)((long)wordCountActual + (word_count - last_word_count));
                                    if (--local_iter == 0L) break;
                                    word_count = 0L;
                                    last_word_count = 0L;
                                    sentence_length = 0;
                                    this.corpus.rewind(numThreads, this.id);
                                    continue;
                                }
                                word = sen[sentence_position];
                                if (word == -1) continue;
                                c = 0;
                                while (c < layer1Size) {
                                    neu1[c] = 0.0;
                                    ++c;
                                }
                                c = 0;
                                while (c < layer1Size) {
                                    neu1e[c] = 0.0;
                                    ++c;
                                }
                                next_random = Word2VecTraining.nextRandom(next_random);
                                b = (int)next_random % window;
                                if (!cbow) break block56;
                                long cw = 0L;
                                a = b;
                                while (a < window * 2 + 1 - b) {
                                    if (a != window && (c = sentence_position - window + a) >= 0 && c < sentence_length && (last_word = sen[c]) != -1) {
                                        c = 0;
                                        while (c < layer1Size) {
                                            int n = c;
                                            neu1[n] = neu1[n] + syn0[c + last_word * layer1Size];
                                            ++c;
                                        }
                                        ++cw;
                                    }
                                    ++a;
                                }
                                if (cw == 0L) break block57;
                                c = 0;
                                while (c < layer1Size) {
                                    int n = c++;
                                    neu1[n] = neu1[n] / (double)cw;
                                }
                                if (hs) {
                                    d = 0;
                                    while (d < this.vocab[word].codelen) {
                                        f = 0.0;
                                        l2 = this.vocab[word].point[d] * layer1Size;
                                        c = 0;
                                        while (c < layer1Size) {
                                            f += neu1[c] * syn1[c + l2];
                                            ++c;
                                        }
                                        if (!(f <= -6.0) && !(f >= 6.0)) {
                                            f = expTable[(int)((f + 6.0) * 83.0)];
                                            g = ((double)('\u0001' - this.vocab[word].code[d]) - f) * (double)this.alpha;
                                            c = 0;
                                            while (c < layer1Size) {
                                                int n = c;
                                                neu1e[n] = neu1e[n] + g * syn1[c + l2];
                                                ++c;
                                            }
                                            c = 0;
                                            while (c < layer1Size) {
                                                int n = c + l2;
                                                syn1[n] = syn1[n] + g * neu1[c];
                                                ++c;
                                            }
                                        }
                                        ++d;
                                    }
                                }
                                if (negative <= 0) break block58;
                                d = 0;
                                while (d < negative + 1) {
                                    block61: {
                                        block60: {
                                            block59: {
                                                if (d != 0) break block59;
                                                target = word;
                                                label = 1L;
                                                break block60;
                                            }
                                            target = this.table[Math.abs((int)(((next_random = Word2VecTraining.nextRandom(next_random)) >> 16) % 100000000L))];
                                            if (target == 0) {
                                                target = Math.abs((int)(next_random % (long)(this.vocabSize - 1) + 1L));
                                            }
                                            if (target == word) break block61;
                                            label = 0L;
                                        }
                                        l2 = target * layer1Size;
                                        f = 0.0;
                                        c = 0;
                                        while (c < layer1Size) {
                                            f += neu1[c] * syn1neg[c + l2];
                                            ++c;
                                        }
                                        g = f > 6.0 ? (double)((float)(label - 1L) * this.alpha) : (f < -6.0 ? (double)((float)(label - 0L) * this.alpha) : ((double)label - expTable[(int)((f + 6.0) * 83.0)]) * (double)this.alpha);
                                        c = 0;
                                        while (c < layer1Size) {
                                            int n = c;
                                            neu1e[n] = neu1e[n] + g * syn1neg[c + l2];
                                            ++c;
                                        }
                                        c = 0;
                                        while (c < layer1Size) {
                                            int n = c + l2;
                                            syn1neg[n] = syn1neg[n] + g * neu1[c];
                                            ++c;
                                        }
                                    }
                                    ++d;
                                }
                            }
                            a = b;
                            while (a < window * 2 + 1 - b) {
                                if (a != window && (c = sentence_position - window + a) >= 0 && c < sentence_length && (last_word = sen[c]) != -1) {
                                    c = 0;
                                    while (c < layer1Size) {
                                        int n = c + last_word * layer1Size;
                                        syn0[n] = syn0[n] + neu1e[c];
                                        ++c;
                                    }
                                }
                                ++a;
                            }
                            break block57;
                        }
                        a = b;
                        while (a < window * 2 + 1 - b) {
                            block62: {
                                int l1;
                                block63: {
                                    if (a == window || (c = sentence_position - window + a) < 0 || c >= sentence_length || (last_word = sen[c]) == -1) break block62;
                                    l1 = last_word * layer1Size;
                                    c = 0;
                                    while (c < layer1Size) {
                                        neu1e[c] = 0.0;
                                        ++c;
                                    }
                                    if (hs) {
                                        d = 0;
                                        while (d < this.vocab[word].codelen) {
                                            f = 0.0;
                                            l2 = this.vocab[word].point[d] * layer1Size;
                                            c = 0;
                                            while (c < layer1Size) {
                                                f += syn0[c + l1] * syn1[c + l2];
                                                ++c;
                                            }
                                            if (!(f <= -6.0) && !(f >= 6.0)) {
                                                f = expTable[(int)((f + 6.0) * 83.0)];
                                                g = ((double)('\u0001' - this.vocab[word].code[d]) - f) * (double)this.alpha;
                                                c = 0;
                                                while (c < layer1Size) {
                                                    int n = c;
                                                    neu1e[n] = neu1e[n] + g * syn1[c + l2];
                                                    ++c;
                                                }
                                                c = 0;
                                                while (c < layer1Size) {
                                                    int n = c + l2;
                                                    syn1[n] = syn1[n] + g * syn0[c + l1];
                                                    ++c;
                                                }
                                            }
                                            ++d;
                                        }
                                    }
                                    if (negative <= 0) break block63;
                                    d = 0;
                                    while (d < negative + 1) {
                                        block66: {
                                            block65: {
                                                block64: {
                                                    if (d != 0) break block64;
                                                    target = word;
                                                    label = 1L;
                                                    break block65;
                                                }
                                                target = this.table[Math.abs((int)(((next_random = Word2VecTraining.nextRandom(next_random)) >> 16) % 100000000L))];
                                                if (target == 0) {
                                                    target = Math.abs((int)(next_random % (long)(this.vocabSize - 1) + 1L));
                                                }
                                                if (target == word) break block66;
                                                label = 0L;
                                            }
                                            l2 = target * layer1Size;
                                            f = 0.0;
                                            c = 0;
                                            while (c < layer1Size) {
                                                f += syn0[c + l1] * syn1neg[c + l2];
                                                ++c;
                                            }
                                            g = f > 6.0 ? (double)((float)(label - 1L) * this.alpha) : (f < -6.0 ? (double)((float)(label - 0L) * this.alpha) : ((double)label - expTable[(int)((f + 6.0) * 83.0)]) * (double)this.alpha);
                                            c = 0;
                                            while (c < layer1Size) {
                                                int n = c;
                                                neu1e[n] = neu1e[n] + g * syn1neg[c + l2];
                                                ++c;
                                            }
                                            c = 0;
                                            while (c < layer1Size) {
                                                int n = c + l2;
                                                syn1neg[n] = syn1neg[n] + g * syn0[c + l1];
                                                ++c;
                                            }
                                        }
                                        ++d;
                                    }
                                }
                                c = 0;
                                while (c < layer1Size) {
                                    int n = c + l1;
                                    syn0[n] = syn0[n] + neu1e[c];
                                    ++c;
                                }
                            }
                            ++a;
                        }
                    }
                    if (++sentence_position < sentence_length) continue;
                    sentence_length = 0;
                }
                this.corpus.shutdown();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Word2VecTraining word2VecTraining = this.vec;
            synchronized (word2VecTraining) {
                --this.vec.threadCount;
                this.vec.notify();
            }
        }
    }

    static class VocabWordComparator
    implements Comparator<VocabWord> {
        VocabWordComparator() {
        }

        @Override
        public int compare(VocabWord o1, VocabWord o2) {
            return o2.cn - o1.cn;
        }
    }
}

