/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model;

import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.model.crf.CRFModel;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.Table;
import java.util.LinkedList;

public final class CRFSegmentModel
extends CRFModel {
    private int idM;
    private int idE;
    private int idS;

    private CRFSegmentModel() {
    }

    public CRFSegmentModel(ITrie<FeatureFunction> featureFunctionTrie) {
        super(featureFunctionTrie);
    }

    private void initTagSet() {
        this.idM = this.getTagId("M");
        this.idE = this.getTagId("E");
        this.idS = this.getTagId("S");
    }

    @Override
    public boolean load(ByteArray byteArray) {
        boolean result = super.load(byteArray);
        if (result) {
            this.initTagSet();
        }
        return result;
    }

    @Override
    protected void onLoadTxtFinished() {
        super.onLoadTxtFinished();
        this.initTagSet();
    }

    @Override
    public void tag(Table table) {
        int size = table.size();
        if (size == 1) {
            table.setLast(0, "S");
            return;
        }
        double[][] net = new double[size][4];
        int i = 0;
        while (i < size) {
            LinkedList<double[]> scoreList = this.computeScoreList(table, i);
            int tag = 0;
            while (tag < 4) {
                net[i][tag] = CRFSegmentModel.computeScore(scoreList, tag);
                ++tag;
            }
            ++i;
        }
        net[0][this.idM] = -1000.0;
        net[0][this.idE] = -1000.0;
        int[][] from = new int[size][4];
        int i2 = 1;
        while (i2 < size) {
            int now = 0;
            while (now < 4) {
                double maxScore = -1.0E10;
                int pre = 0;
                while (pre < 4) {
                    double score = net[i2 - 1][pre] + this.matrix[pre][now] + net[i2][now];
                    if (score > maxScore) {
                        maxScore = score;
                        from[i2][now] = pre;
                    }
                    ++pre;
                }
                net[i2][now] = maxScore;
                ++now;
            }
            ++i2;
        }
        int maxTag = net[size - 1][this.idS] > net[size - 1][this.idE] ? this.idS : this.idE;
        table.setLast(size - 1, this.id2tag[maxTag]);
        maxTag = from[size - 1][maxTag];
        int i3 = size - 2;
        while (i3 > 0) {
            table.setLast(i3, this.id2tag[maxTag]);
            maxTag = from[i3][maxTag];
            --i3;
        }
        table.setLast(0, this.id2tag[maxTag]);
    }
}

