/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.trigram;

import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.model.trigram.frequency.Probability;
import java.io.DataOutputStream;
import java.util.LinkedList;
import java.util.List;

public class CharacterBasedGenerativeModel
implements ICacheAble {
    double l1;
    double l2;
    double l3;
    Probability tf = new Probability();
    int[][][] transMatrix;
    static final char[] id2tag = new char[]{'b', 'm', 'e', 's', 'x'};
    static final char[] bos = new char[]{'\b', 'x'};
    static final double inf = -1.0E10;
    static final int[][] probableTail;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 2};
        nArrayArray[2] = new int[]{2, 3};
        nArrayArray[3] = new int[]{3, 3};
        probableTail = nArrayArray;
    }

    public CharacterBasedGenerativeModel() {
        int[] nullArray = new int[5];
        this.transMatrix = new int[5][][];
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = nullArray;
        int[] nArray = new int[5];
        nArray[1] = 150;
        nArray[2] = 330;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[5];
        nArray2[0] = 160;
        nArray2[3] = 168;
        nArray2[4] = 20;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = nullArray;
        nArrayArray[4] = nullArray;
        this.transMatrix[0] = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        nArrayArray2[0] = nullArray;
        int[] nArray3 = new int[5];
        nArray3[1] = 35;
        nArray3[2] = 150;
        nArrayArray2[1] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[0] = 210;
        nArray4[3] = 263;
        nArray4[4] = 3;
        nArrayArray2[2] = nArray4;
        nArrayArray2[3] = nullArray;
        nArrayArray2[4] = nullArray;
        this.transMatrix[1] = nArrayArray2;
        int[][] nArrayArray3 = new int[5][];
        int[] nArray5 = new int[5];
        nArray5[1] = 200;
        nArray5[2] = 1600;
        nArrayArray3[0] = nArray5;
        nArrayArray3[1] = nullArray;
        nArrayArray3[2] = nullArray;
        int[] nArray6 = new int[5];
        nArray6[0] = 1080;
        nArray6[3] = 650;
        nArray6[4] = 205;
        nArrayArray3[3] = nArray6;
        nArrayArray3[4] = nullArray;
        this.transMatrix[2] = nArrayArray3;
        int[][] nArrayArray4 = new int[5][];
        int[] nArray7 = new int[5];
        nArray7[1] = 200;
        nArray7[2] = 1600;
        nArrayArray4[0] = nArray7;
        nArrayArray4[1] = nullArray;
        nArrayArray4[2] = nullArray;
        int[] nArray8 = new int[5];
        nArray8[0] = 640;
        nArray8[3] = 700;
        nArray8[4] = 63;
        nArrayArray4[3] = nArray8;
        nArrayArray4[4] = nullArray;
        this.transMatrix[3] = nArrayArray4;
        int[][] nArrayArray5 = new int[5][];
        int[] nArray9 = new int[5];
        nArray9[1] = 30;
        nArray9[2] = 150;
        nArrayArray5[0] = nArray9;
        nArrayArray5[1] = nullArray;
        nArrayArray5[2] = nullArray;
        int[] nArray10 = new int[5];
        nArray10[0] = 60;
        nArray10[3] = 50;
        nArray10[4] = 3;
        nArrayArray5[3] = nArray10;
        int[] nArray11 = new int[5];
        nArray11[0] = 180;
        nArray11[3] = 120;
        nArrayArray5[4] = nArray11;
        this.transMatrix[4] = nArrayArray5;
    }

    public void learn(List<Word> wordList) {
        LinkedList<char[]> sentence = new LinkedList<char[]>();
        for (IWord iWord : wordList) {
            String word = iWord.getValue();
            if (word.length() == 1) {
                sentence.add(new char[]{word.charAt(0), 's'});
                continue;
            }
            sentence.add(new char[]{word.charAt(0), 'b'});
            int i = 1;
            while (i < word.length() - 1) {
                sentence.add(new char[]{word.charAt(i), 'm'});
                ++i;
            }
            sentence.add(new char[]{word.charAt(word.length() - 1), 'e'});
        }
        char[][] cArrayArray = new char[3][];
        cArrayArray[1] = bos;
        cArrayArray[2] = bos;
        this.tf.add(1, new char[][]{bos, bos});
        this.tf.add(2, new char[][]{bos});
        for (char[] i : sentence) {
            System.arraycopy(cArrayArray, 1, cArrayArray, 0, 2);
            cArrayArray[2] = i;
            this.tf.add(1, new char[][]{i});
            this.tf.add(1, new char[][]{cArrayArray[1], cArrayArray[2]});
            this.tf.add(1, cArrayArray);
        }
    }

    public void train() {
        double tl1 = 0.0;
        double tl2 = 0.0;
        double tl3 = 0.0;
        for (String key : this.tf.d.keySet()) {
            if (key.length() != 6) continue;
            char[][] now = new char[][]{{key.charAt(0), key.charAt(1)}, {key.charAt(2), key.charAt(3)}, {key.charAt(4), key.charAt(5)}};
            double c3 = CharacterBasedGenerativeModel.div(this.tf.get(now) - 1, this.tf.get(new char[][]{now[0], now[1]}) - 1);
            double c2 = CharacterBasedGenerativeModel.div(this.tf.get(new char[][]{now[1], now[2]}) - 1, this.tf.get(now[1]) - 1);
            double c1 = CharacterBasedGenerativeModel.div(this.tf.get(now[2]) - 1, this.tf.getsum() - 1);
            if (c3 >= c1 && c3 >= c2) {
                tl3 += (double)this.tf.get(key.toCharArray());
                continue;
            }
            if (c2 >= c1 && c2 >= c3) {
                tl2 += (double)this.tf.get(key.toCharArray());
                continue;
            }
            if (!(c1 >= c2) || !(c1 >= c3)) continue;
            tl1 += (double)this.tf.get(key.toCharArray());
        }
        this.l1 = CharacterBasedGenerativeModel.div(tl1, tl1 + tl2 + tl3);
        this.l2 = CharacterBasedGenerativeModel.div(tl2, tl1 + tl2 + tl3);
        this.l3 = CharacterBasedGenerativeModel.div(tl3, tl1 + tl2 + tl3);
    }

    double log_prob(char s1, int i1, char s2, int i2, char s3, int i3) {
        if (this.transMatrix[i1][i2][i3] == 0) {
            return -1.0E10;
        }
        char t1 = id2tag[i1];
        char t2 = id2tag[i2];
        char t3 = id2tag[i3];
        double uni = this.l1 * this.tf.freq(s3, t3);
        double bi = CharacterBasedGenerativeModel.div(this.l2 * (double)this.tf.get(s2, t2, s3, t3), (double)this.tf.get(s2, t2));
        double tri = CharacterBasedGenerativeModel.div(this.l3 * (double)this.tf.get(s1, t1, s2, t2, s3, t3), (double)this.tf.get(s1, t1, s2, t2));
        if (uni + bi + tri == 0.0) {
            return -1.0E10;
        }
        return Math.log(uni + bi + tri);
    }

    public char[] tag(char[] charArray) {
        int t;
        int s;
        if (charArray.length == 0) {
            return new char[0];
        }
        if (charArray.length == 1) {
            return new char[]{'s'};
        }
        char[] tag = new char[charArray.length];
        double[][] now = new double[4][4];
        double[] first = new double[4];
        int[][][] link = new int[charArray.length][4][4];
        int s2 = 0;
        while (s2 < 4) {
            double p;
            first[s2] = p = s2 == 1 || s2 == 2 ? -1.0E10 : this.log_prob(bos[0], 4, bos[0], 4, charArray[0], s2);
            ++s2;
        }
        int f = 0;
        while (f < 4) {
            int s3 = 0;
            while (s3 < 4) {
                double p;
                now[f][s3] = p = first[f] + this.log_prob(bos[0], 4, charArray[0], f, charArray[1], s3);
                link[1][f][s3] = f;
                ++s3;
            }
            ++f;
        }
        double[][] pre = new double[4][4];
        int i = 2;
        while (i < charArray.length) {
            double[][] _ = pre;
            pre = now;
            now = _;
            s = 0;
            while (s < 4) {
                t = 0;
                while (t < 4) {
                    now[s][t] = -1.0E20;
                    int f2 = 0;
                    while (f2 < 4) {
                        double p = pre[f2][s] + this.log_prob(charArray[i - 2], f2, charArray[i - 1], s, charArray[i], t);
                        if (p > now[s][t]) {
                            now[s][t] = p;
                            link[i][s][t] = f2;
                        }
                        ++f2;
                    }
                    ++t;
                }
                ++s;
            }
            ++i;
        }
        double score = (double)charArray.length * -1.0E10;
        s = 0;
        t = 0;
        int i2 = 0;
        while (i2 < probableTail.length) {
            int[] state = probableTail[i2];
            if (now[state[0]][state[1]] > score) {
                score = now[state[0]][state[1]];
                s = state[0];
                t = state[1];
            }
            ++i2;
        }
        i2 = link.length - 1;
        while (i2 >= 0) {
            tag[i2] = id2tag[t];
            int f3 = link[i2][s][t];
            t = s;
            s = f3;
            --i2;
        }
        return tag;
    }

    private static double div(int v1, int v2) {
        if (v2 == 0) {
            return 0.0;
        }
        return (double)v1 / (double)v2;
    }

    private static double div(double v1, double v2) {
        if (v2 == 0.0) {
            return 0.0;
        }
        return v1 / v2;
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeDouble(this.l1);
        out.writeDouble(this.l2);
        out.writeDouble(this.l3);
        this.tf.save(out);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.l1 = byteArray.nextDouble();
        this.l2 = byteArray.nextDouble();
        this.l3 = byteArray.nextDouble();
        this.tf.load(byteArray);
        return true;
    }
}

