/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Viterbi;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.recognition.nr.JapanesePersonRecognition;
import com.hankcs.hanlp.recognition.nr.PersonRecognition;
import com.hankcs.hanlp.recognition.nr.TranslatedPersonRecognition;
import com.hankcs.hanlp.recognition.ns.PlaceRecognition;
import com.hankcs.hanlp.recognition.nt.OrganizationRecognition;
import com.hankcs.hanlp.seg.WordBasedGenerativeModelSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.LinkedList;
import java.util.List;

public class ViterbiSegment
extends WordBasedGenerativeModelSegment {
    @Override
    protected List<Term> segSentence(char[] sentence) {
        WordNet wordNetAll = new WordNet(sentence);
        this.GenerateWordNet(wordNetAll);
        if (HanLP.Config.DEBUG) {
            System.out.printf("\u7c97\u5206\u8bcd\u7f51\uff1a\n%s\n", wordNetAll);
        }
        List<Vertex> vertexList = ViterbiSegment.viterbi(wordNetAll);
        if (this.config.useCustomDictionary) {
            if (this.config.indexMode) {
                ViterbiSegment.combineByCustomDictionary(vertexList, wordNetAll);
            } else {
                ViterbiSegment.combineByCustomDictionary(vertexList);
            }
        }
        if (HanLP.Config.DEBUG) {
            System.out.println("\u7c97\u5206\u7ed3\u679c" + ViterbiSegment.convert(vertexList, false));
        }
        if (this.config.numberQuantifierRecognize) {
            this.mergeNumberQuantifier(vertexList, wordNetAll, this.config);
        }
        if (this.config.ner) {
            WordNet wordNetOptimum = new WordNet(sentence, vertexList);
            int preSize = wordNetOptimum.size();
            if (this.config.nameRecognize) {
                PersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.translatedNameRecognize) {
                TranslatedPersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.japaneseNameRecognize) {
                JapanesePersonRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.placeRecognize) {
                PlaceRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (this.config.organizationRecognize) {
                vertexList = ViterbiSegment.viterbi(wordNetOptimum);
                wordNetOptimum.clear();
                wordNetOptimum.addAll(vertexList);
                preSize = wordNetOptimum.size();
                OrganizationRecognition.Recognition(vertexList, wordNetOptimum, wordNetAll);
            }
            if (wordNetOptimum.size() != preSize) {
                vertexList = ViterbiSegment.viterbi(wordNetOptimum);
                if (HanLP.Config.DEBUG) {
                    System.out.printf("\u7ec6\u5206\u8bcd\u7f51\uff1a\n%s\n", wordNetOptimum);
                }
            }
        }
        if (this.config.indexMode) {
            return ViterbiSegment.decorateResultForIndexMode(vertexList, wordNetAll);
        }
        if (this.config.speechTagging) {
            ViterbiSegment.speechTagging(vertexList);
        }
        return ViterbiSegment.convert(vertexList, this.config.offset);
    }

    private static List<Vertex> viterbi(WordNet wordNet) {
        LinkedList<Vertex>[] nodes = wordNet.getVertexes();
        LinkedList<Vertex> vertexList = new LinkedList<Vertex>();
        for (Vertex node : nodes[1]) {
            node.updateFrom(nodes[0].getFirst());
        }
        int i = 1;
        while (i < nodes.length - 1) {
            LinkedList<Vertex> nodeArray = nodes[i];
            if (nodeArray != null) {
                for (Vertex node : nodeArray) {
                    if (node.from == null) continue;
                    for (Vertex to : nodes[i + node.realWord.length()]) {
                        to.updateFrom(node);
                    }
                }
            }
            ++i;
        }
        Vertex from = nodes[nodes.length - 1].getFirst();
        while (from != null) {
            vertexList.addFirst(from);
            from = from.from;
        }
        return vertexList;
    }
}

