/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.suggest;

import com.hankcs.hanlp.suggest.ISuggester;
import com.hankcs.hanlp.suggest.scorer.BaseScorer;
import com.hankcs.hanlp.suggest.scorer.IScorer;
import com.hankcs.hanlp.suggest.scorer.editdistance.EditDistanceScorer;
import com.hankcs.hanlp.suggest.scorer.lexeme.IdVectorScorer;
import com.hankcs.hanlp.suggest.scorer.pinyin.PinyinScorer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Suggester
implements ISuggester {
    List<BaseScorer> scorerList;

    public Suggester() {
        this.scorerList = new ArrayList<BaseScorer>();
        this.scorerList.add(new IdVectorScorer());
        this.scorerList.add(new EditDistanceScorer());
        this.scorerList.add(new PinyinScorer());
    }

    public Suggester(List<BaseScorer> scorerList) {
        this.scorerList = scorerList;
    }

    public Suggester(BaseScorer ... scorers) {
        this.scorerList = new ArrayList<BaseScorer>(scorers.length);
        BaseScorer[] baseScorerArray = scorers;
        int n = scorers.length;
        int n2 = 0;
        while (n2 < n) {
            BaseScorer scorer = baseScorerArray[n2];
            this.scorerList.add(scorer);
            ++n2;
        }
    }

    @Override
    public void addSentence(String sentence) {
        for (IScorer iScorer : this.scorerList) {
            iScorer.addSentence(sentence);
        }
    }

    @Override
    public void removeAllSentences() {
        for (IScorer iScorer : this.scorerList) {
            iScorer.removeAllSentences();
        }
    }

    @Override
    public List<String> suggest(String key, int size) {
        ArrayList<String> resultList = new ArrayList<String>(size);
        TreeMap<String, Double> scoreMap = new TreeMap<String, Double>();
        for (BaseScorer baseScorer : this.scorerList) {
            Map<String, Double> map = baseScorer.computeScore(key);
            Double max = Suggester.max(map);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                Double score = scoreMap.get(entry.getKey());
                if (score == null) {
                    score = 0.0;
                }
                scoreMap.put(entry.getKey(), score / max + entry.getValue() * baseScorer.boost);
            }
        }
        for (Map.Entry entry : Suggester.sortScoreMap(scoreMap).entrySet()) {
            for (String sentence : (Set)entry.getValue()) {
                if (resultList.size() >= size) {
                    return resultList;
                }
                resultList.add(sentence);
            }
        }
        return resultList;
    }

    private static TreeMap<Double, Set<String>> sortScoreMap(TreeMap<String, Double> scoreMap) {
        TreeMap<Double, Set<String>> result = new TreeMap<Double, Set<String>>(Collections.reverseOrder());
        for (Map.Entry<String, Double> entry : scoreMap.entrySet()) {
            Set<String> sentenceSet = result.get(entry.getValue());
            if (sentenceSet == null) {
                sentenceSet = new HashSet<String>();
                result.put(entry.getValue(), sentenceSet);
            }
            sentenceSet.add(entry.getKey());
        }
        return result;
    }

    private static Double max(Map<String, Double> map) {
        Double theMax = 0.0;
        for (Double v : map.values()) {
            theMax = Math.max(theMax, v);
        }
        return theMax;
    }
}

