/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.utility;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.seg.common.Term;
import java.util.LinkedList;
import java.util.List;

public class SentencesUtil {
    public static List<String> toSentenceList(String content) {
        return SentencesUtil.toSentenceList(content.toCharArray());
    }

    public static List<String> toSentenceList(char[] chars) {
        StringBuilder sb = new StringBuilder();
        LinkedList<String> sentences = new LinkedList<String>();
        int i = 0;
        while (i < chars.length) {
            if (sb.length() != 0 || !Character.isWhitespace(chars[i]) && chars[i] != ' ') {
                sb.append(chars[i]);
                switch (chars[i]) {
                    case '.': {
                        if (i >= chars.length - 1 || chars[i + 1] <= '\u0080') break;
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                        break;
                    }
                    case '\u2026': {
                        if (i >= chars.length - 1 || chars[i + 1] != '\u2026') break;
                        sb.append('\u2026');
                        ++i;
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                        break;
                    }
                    case '\t': 
                    case ' ': 
                    case ',': 
                    case '\u00a0': 
                    case '\u3002': 
                    case '\uff0c': {
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                        break;
                    }
                    case ';': 
                    case '\uff1b': {
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                        break;
                    }
                    case '!': 
                    case '\uff01': {
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                        break;
                    }
                    case '?': 
                    case '\uff1f': {
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        SentencesUtil.insertIntoList(sb, sentences);
                        sb = new StringBuilder();
                    }
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            SentencesUtil.insertIntoList(sb, sentences);
        }
        return sentences;
    }

    private static void insertIntoList(StringBuilder sb, List<String> sentences) {
        String content = sb.toString().trim();
        if (content.length() > 0) {
            sentences.add(content);
        }
    }

    public static boolean hasNature(List<Term> sentence, Nature nature) {
        for (Term term : sentence) {
            if (term.nature != nature) continue;
            return true;
        }
        return false;
    }
}

