/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.UnboundedBox2DException;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LineArc2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polygons2D;
import math.utils.EqualUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Box2D
implements GeometricObject2D,
Cloneable {
    public static final Box2D UNIT_SQUARE_BOX = Box2D.create(0.0, 1.0, 0.0, 1.0);
    public static final Box2D INFINITE_BOX = Box2D.create(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private double xmin = 0.0;
    private double xmax = 0.0;
    private double ymin = 0.0;
    private double ymax = 0.0;

    @Deprecated
    public static Box2D create(double xmin, double xmax, double ymin, double ymax) {
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Deprecated
    public static Box2D create(Point2D p1, Point2D p2) {
        return new Box2D(p1, p2);
    }

    public Box2D() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Box2D(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public Box2D(Rectangle2D rect) {
        this(rect.getX(), rect.getX() + rect.getWidth(), rect.getY(), rect.getY() + rect.getHeight());
    }

    public Box2D(Point2D p1, Point2D p2) {
        double x1 = p1.x();
        double y1 = p1.y();
        double x2 = p2.x();
        double y2 = p2.y();
        this.xmin = Math.min(x1, x2);
        this.xmax = Math.max(x1, x2);
        this.ymin = Math.min(y1, y2);
        this.ymax = Math.max(y1, y2);
    }

    public Box2D(Point2D point, double w, double h) {
        this(point.x(), point.x() + w, point.y(), point.y() + h);
    }

    public double getMinX() {
        return this.xmin;
    }

    public double getMinY() {
        return this.ymin;
    }

    public double getMaxX() {
        return this.xmax;
    }

    public double getMaxY() {
        return this.ymax;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public boolean isBounded() {
        if (Double.isInfinite(this.xmin)) {
            return false;
        }
        if (Double.isInfinite(this.ymin)) {
            return false;
        }
        if (Double.isInfinite(this.xmax)) {
            return false;
        }
        return !Double.isInfinite(this.ymax);
    }

    public boolean contains(Point2D point) {
        double x = point.x();
        double y = point.y();
        if (x < this.xmin) {
            return false;
        }
        if (y < this.ymin) {
            return false;
        }
        if (x > this.xmax) {
            return false;
        }
        return !(y > this.ymax);
    }

    public boolean contains(double x, double y) {
        if (x < this.xmin) {
            return false;
        }
        if (y < this.ymin) {
            return false;
        }
        if (x > this.xmax) {
            return false;
        }
        return !(y > this.ymax);
    }

    public boolean containsBounds(Shape2D shape) {
        if (!shape.isBounded()) {
            return false;
        }
        for (Point2D point : shape.boundingBox().vertices()) {
            if (this.contains(point)) continue;
            return false;
        }
        return true;
    }

    public Collection<StraightLine2D> clippingLines() {
        ArrayList<StraightLine2D> lines = new ArrayList<StraightLine2D>(4);
        if (Box2D.isFinite(this.ymin)) {
            lines.add(new StraightLine2D(0.0, this.ymin, 1.0, 0.0));
        }
        if (Box2D.isFinite(this.xmax)) {
            lines.add(new StraightLine2D(this.xmax, 0.0, 0.0, 1.0));
        }
        if (Box2D.isFinite(this.ymax)) {
            lines.add(new StraightLine2D(0.0, this.ymax, -1.0, 0.0));
        }
        if (Box2D.isFinite(this.xmin)) {
            lines.add(new StraightLine2D(this.xmin, 0.0, 0.0, -1.0));
        }
        return lines;
    }

    public Collection<LinearShape2D> edges() {
        ArrayList<LinearShape2D> edges = new ArrayList<LinearShape2D>(4);
        if (this.isBounded()) {
            edges.add(new LineSegment2D(this.xmin, this.ymin, this.xmax, this.ymin));
            edges.add(new LineSegment2D(this.xmax, this.ymin, this.xmax, this.ymax));
            edges.add(new LineSegment2D(this.xmax, this.ymax, this.xmin, this.ymax));
            edges.add(new LineSegment2D(this.xmin, this.ymax, this.xmin, this.ymin));
            return edges;
        }
        if (!Double.isInfinite(this.ymin)) {
            if (Double.isInfinite(this.xmin) && Double.isInfinite(this.xmax)) {
                edges.add(new StraightLine2D(0.0, this.ymin, 1.0, 0.0));
            } else if (!Double.isInfinite(this.xmin) && !Double.isInfinite(this.xmax)) {
                edges.add(new LineSegment2D(this.xmin, this.ymin, this.xmax, this.ymin));
            } else {
                edges.add(new LineArc2D(0.0, this.ymin, 1.0, 0.0, this.xmin, this.xmax));
            }
        }
        if (!Double.isInfinite(this.xmax)) {
            if (Double.isInfinite(this.ymin) && Double.isInfinite(this.ymax)) {
                edges.add(new StraightLine2D(this.xmax, 0.0, 0.0, 1.0));
            } else if (!Double.isInfinite(this.ymin) && !Double.isInfinite(this.ymax)) {
                edges.add(new LineSegment2D(this.xmax, this.ymin, this.xmax, this.ymax));
            } else {
                edges.add(new LineArc2D(this.xmax, 0.0, 0.0, 1.0, this.ymin, this.ymax));
            }
        }
        if (!Double.isInfinite(this.ymax)) {
            if (Double.isInfinite(this.xmin) && Double.isInfinite(this.xmax)) {
                edges.add(new StraightLine2D(0.0, this.ymax, 1.0, 0.0));
            } else if (!Double.isInfinite(this.xmin) && !Double.isInfinite(this.xmax)) {
                edges.add(new LineSegment2D(this.xmax, this.ymax, this.xmin, this.ymax));
            } else {
                edges.add(new LineArc2D(0.0, this.ymin, 1.0, 0.0, this.xmin, this.xmax).reverse());
            }
        }
        if (!Double.isInfinite(this.xmin)) {
            if (Double.isInfinite(this.ymin) && Double.isInfinite(this.ymax)) {
                edges.add(new StraightLine2D(this.xmin, 0.0, 0.0, -1.0));
            } else if (!Double.isInfinite(this.ymin) && !Double.isInfinite(this.ymax)) {
                edges.add(new LineSegment2D(this.xmin, this.ymax, this.xmin, this.ymin));
            } else {
                edges.add(new LineArc2D(this.xmin, 0.0, 0.0, 1.0, this.ymin, this.ymax).reverse());
            }
        }
        return edges;
    }

    public Boundary2D boundary() {
        boolean by1;
        if (this.isBounded()) {
            Point2D[] pts = new Point2D[]{new Point2D(this.xmin, this.ymin), new Point2D(this.xmax, this.ymin), new Point2D(this.xmax, this.ymax), new Point2D(this.xmin, this.ymax)};
            return new LinearRing2D(pts);
        }
        boolean bx0 = !Double.isInfinite(this.xmin);
        boolean bx1 = !Double.isInfinite(this.xmax);
        boolean by0 = !Double.isInfinite(this.ymin);
        boolean bl = by1 = !Double.isInfinite(this.ymax);
        if (!bx0 && !bx1) {
            if (!by0 && !by1) {
                return new ContourArray2D();
            }
            if (by0 && !by1) {
                return new StraightLine2D(0.0, this.ymin, 1.0, 0.0);
            }
            if (!by0 && by1) {
                return new StraightLine2D(0.0, this.ymax, -1.0, 0.0);
            }
            return new ContourArray2D<StraightLine2D[]>(new StraightLine2D[]{new StraightLine2D(0.0, this.ymin, 1.0, 0.0), new StraightLine2D(0.0, this.ymax, -1.0, 0.0)});
        }
        if (!by0 && !by1) {
            if (!bx0 && !bx1) {
                return new ContourArray2D();
            }
            if (bx0 && !bx1) {
                return new StraightLine2D(this.xmin, 0.0, 0.0, -1.0);
            }
            if (!bx0 && bx1) {
                return new StraightLine2D(this.xmax, 0.0, 0.0, 1.0);
            }
            return new ContourArray2D<StraightLine2D[]>(new StraightLine2D[]{new StraightLine2D(this.xmin, 0.0, 0.0, -1.0), new StraightLine2D(this.xmax, 0.0, 0.0, 1.0)});
        }
        if (bx0 && by0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmin, this.ymin, 0.0, -1.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmin, this.ymin, 1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx1 && by0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmax, this.ymin, 1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmax, this.ymin, 0.0, 1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx1 && by1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmax, this.ymax, 0.0, 1.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmax, this.ymax, -1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx0 && by1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmin, this.ymax, -1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmin, this.ymax, 0.0, -1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmin, this.ymax, -1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmin, this.ymax, this.xmin, this.ymin), new LineArc2D(this.xmin, this.ymin, 1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmax, this.ymin, 1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmax, this.ymin, this.xmax, this.ymax), new LineArc2D(this.xmax, this.ymax, -1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (by0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmin, this.ymin, 0.0, -1.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmin, this.ymin, this.xmax, this.ymin), new LineArc2D(this.xmax, this.ymin, 0.0, 1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (by1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmax, this.ymax, 0.0, 1.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmax, this.ymax, this.xmin, this.ymax), new LineArc2D(this.xmin, this.ymax, 0.0, -1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        return null;
    }

    public Collection<Point2D> vertices() {
        ArrayList<Point2D> points = new ArrayList<Point2D>(4);
        boolean bx0 = Box2D.isFinite(this.xmin);
        boolean bx1 = Box2D.isFinite(this.xmax);
        boolean by0 = Box2D.isFinite(this.ymin);
        boolean by1 = Box2D.isFinite(this.ymax);
        if (bx0 && by0) {
            points.add(new Point2D(this.xmin, this.ymin));
        }
        if (bx1 && by0) {
            points.add(new Point2D(this.xmax, this.ymin));
        }
        if (bx0 && by1) {
            points.add(new Point2D(this.xmin, this.ymax));
        }
        if (bx1 && by1) {
            points.add(new Point2D(this.xmax, this.ymax));
        }
        return points;
    }

    private static final boolean isFinite(double value) {
        if (Double.isInfinite(value)) {
            return false;
        }
        return !Double.isNaN(value);
    }

    public int vertexNumber() {
        return this.vertices().size();
    }

    public Box2D union(Box2D box) {
        double xmin = Math.min(this.xmin, box.xmin);
        double xmax = Math.max(this.xmax, box.xmax);
        double ymin = Math.min(this.ymin, box.ymin);
        double ymax = Math.max(this.ymax, box.ymax);
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public Box2D intersection(Box2D box) {
        double xmin = Math.max(this.xmin, box.xmin);
        double xmax = Math.min(this.xmax, box.xmax);
        double ymin = Math.max(this.ymin, box.ymin);
        double ymax = Math.min(this.ymax, box.ymax);
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public Box2D merge(Box2D box) {
        this.xmin = Math.min(this.xmin, box.xmin);
        this.xmax = Math.max(this.xmax, box.xmax);
        this.ymin = Math.min(this.ymin, box.ymin);
        this.ymax = Math.max(this.ymax, box.ymax);
        return this;
    }

    public Box2D clip(Box2D box) {
        this.xmin = Math.max(this.xmin, box.xmin);
        this.xmax = Math.min(this.xmax, box.xmax);
        this.ymin = Math.max(this.ymin, box.ymin);
        this.ymax = Math.min(this.ymax, box.ymax);
        return this;
    }

    public Box2D transform(AffineTransform2D trans) {
        if (!this.isBounded()) {
            return INFINITE_BOX;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (Point2D point : this.vertices()) {
            point = point.transform(trans);
            xmin = Math.min(xmin, point.x());
            ymin = Math.min(ymin, point.y());
            xmax = Math.max(xmax, point.x());
            ymax = Math.max(ymax, point.y());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public Rectangle asAwtRectangle() {
        int xr = (int)Math.floor(this.xmin);
        int yr = (int)Math.floor(this.ymin);
        int wr = (int)Math.ceil(this.xmax - (double)xr);
        int hr = (int)Math.ceil(this.ymax - (double)yr);
        return new Rectangle(xr, yr, wr, hr);
    }

    public Rectangle2D asAwtRectangle2D() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public Polygon2D asRectangle() {
        return Polygons2D.createRectangle(this.xmin, this.ymin, this.xmax, this.ymax);
    }

    public void draw(Graphics2D g2) {
        if (!this.isBounded()) {
            throw new UnboundedBox2DException(this);
        }
        this.boundary().draw(g2);
    }

    public void fill(Graphics2D g2) {
        if (!this.isBounded()) {
            throw new UnboundedBox2DException(this);
        }
        this.boundary().fill(g2);
    }

    @Deprecated
    public Box2D boundingBox() {
        return new Box2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Box2D)) {
            return false;
        }
        Box2D box = (Box2D)obj;
        if (Math.abs(this.xmin - box.xmin) > eps) {
            return false;
        }
        if (Math.abs(this.xmax - box.xmax) > eps) {
            return false;
        }
        if (Math.abs(this.ymin - box.ymin) > eps) {
            return false;
        }
        return !(Math.abs(this.ymax - box.ymax) > eps);
    }

    public String toString() {
        return new String("Box2D(" + this.xmin + "," + this.xmax + "," + this.ymin + "," + this.ymax + ")");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Box2D)) {
            return false;
        }
        Box2D that = (Box2D)obj;
        if (!EqualUtils.areEqual(this.xmin, that.xmin)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.xmax, that.xmax)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.ymin, that.ymin)) {
            return false;
        }
        return EqualUtils.areEqual(this.ymax, that.ymax);
    }

    @Deprecated
    public Box2D clone() {
        return new Box2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }
}

