/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.curve;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.line.LinearShape2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurveArray2D<T extends Curve2D>
implements CurveSet2D<T>,
Iterable<T>,
Cloneable {
    protected ArrayList<T> curves;

    public static <T extends Curve2D> CurveArray2D<T> create(Collection<T> curves) {
        return new CurveArray2D<T>(curves);
    }

    public static <T extends Curve2D> CurveArray2D<T> create(T ... curves) {
        return new CurveArray2D(curves);
    }

    public CurveArray2D() {
        this.curves = new ArrayList();
    }

    public CurveArray2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CurveArray2D(T ... curves) {
        this(curves.length);
        T[] TArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.curves.add(element);
            ++n2;
        }
    }

    public CurveArray2D(CurveSet2D<? extends T> set) {
        this(set.size());
        for (Curve2D curve : set) {
            this.curves.add(curve);
        }
    }

    public CurveArray2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    @Override
    public double localPosition(double t) {
        int i = this.curveIndex(t);
        Curve2D curve = (Curve2D)this.curves.get(i);
        double t0 = curve.t0();
        double t1 = curve.t1();
        return Curves2D.fromUnitSegment(t - (double)(2 * i), t0, t1);
    }

    @Override
    public double globalPosition(int i, double t) {
        Curve2D curve = (Curve2D)this.curves.get(i);
        double t0 = curve.t0();
        double t1 = curve.t1();
        return Curves2D.toUnitSegment(t, t0, t1) + (double)(i * 2);
    }

    @Override
    public int curveIndex(double t) {
        if (this.curves.size() == 0) {
            return 0;
        }
        if (t > (double)(this.curves.size() * 2 - 1)) {
            return this.curves.size() - 1;
        }
        int nc = (int)Math.floor(t);
        int indc = (int)Math.floor(nc / 2);
        if (indc * 2 == nc) {
            return indc;
        }
        return t - (double)nc < 0.5 ? indc : indc + 1;
    }

    @Override
    public boolean add(T curve) {
        if (this.curves.contains(curve)) {
            return false;
        }
        return this.curves.add(curve);
    }

    @Override
    public void add(int index, T curve) {
        this.curves.add(index, curve);
    }

    @Override
    public boolean remove(T curve) {
        return this.curves.remove(curve);
    }

    @Override
    public T remove(int index) {
        return (T)((Curve2D)this.curves.remove(index));
    }

    @Override
    public boolean contains(T curve) {
        return this.curves.contains(curve);
    }

    @Override
    public int indexOf(T curve) {
        return this.curves.indexOf(curve);
    }

    @Override
    public void clear() {
        this.curves.clear();
    }

    @Override
    public Collection<T> curves() {
        return this.curves;
    }

    @Override
    public T get(int index) {
        return (T)((Curve2D)this.curves.get(index));
    }

    @Override
    public T childCurve(double t) {
        if (this.curves.size() == 0) {
            return null;
        }
        return (T)((Curve2D)this.curves.get(this.curveIndex(t)));
    }

    @Override
    public T firstCurve() {
        if (this.curves.size() == 0) {
            return null;
        }
        return (T)((Curve2D)this.curves.get(0));
    }

    @Override
    public T lastCurve() {
        if (this.curves.size() == 0) {
            return null;
        }
        return (T)((Curve2D)this.curves.get(this.curves.size() - 1));
    }

    @Override
    public int size() {
        return this.curves.size();
    }

    @Override
    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        ArrayList<Point2D> intersect = new ArrayList<Point2D>();
        for (Curve2D curve : this.curves) {
            intersect.addAll(curve.intersections(line));
        }
        return intersect;
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return Math.max(this.curves.size() * 2 - 1, 0);
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        if (this.curves.size() == 0) {
            return null;
        }
        if (t < this.t0()) {
            return this.firstCurve().firstPoint();
        }
        if (t > this.t1()) {
            return this.lastCurve().lastPoint();
        }
        int nc = (int)Math.floor(t);
        int indc = (int)Math.floor(nc / 2);
        if (indc * 2 == nc) {
            Curve2D curve = (Curve2D)this.curves.get(indc);
            double pos = Curves2D.fromUnitSegment(t - (double)nc, curve.t0(), curve.t1());
            return curve.point(pos);
        }
        if (t - (double)nc < 0.5) {
            return ((Curve2D)this.curves.get(indc)).lastPoint();
        }
        return ((Curve2D)this.curves.get(indc + 1)).firstPoint();
    }

    @Override
    public Point2D firstPoint() {
        if (this.curves.size() == 0) {
            return null;
        }
        return this.firstCurve().firstPoint();
    }

    @Override
    public Point2D lastPoint() {
        if (this.curves.size() == 0) {
            return null;
        }
        return this.lastCurve().lastPoint();
    }

    @Override
    public Collection<Point2D> singularPoints() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        double eps = 1.0E-12;
        for (Curve2D curve : this.curves) {
            for (Point2D point : curve.singularPoints()) {
                this.addPointWithGuardDistance(points, point, eps);
            }
            if (!Curves2D.isLeftInfinite(curve)) {
                this.addPointWithGuardDistance(points, curve.firstPoint(), eps);
            }
            if (Curves2D.isRightInfinite(curve)) continue;
            this.addPointWithGuardDistance(points, curve.lastPoint(), eps);
        }
        return points;
    }

    private void addPointWithGuardDistance(Collection<Point2D> pointSet, Point2D point, double eps) {
        for (Point2D p0 : pointSet) {
            if (!p0.almostEquals(point, eps)) continue;
            return;
        }
        pointSet.add(point);
    }

    @Override
    public Collection<Point2D> vertices() {
        return this.singularPoints();
    }

    @Override
    public boolean isSingular(double pos) {
        if (Math.abs(pos - (double)Math.round(pos)) < 1.0E-12) {
            return true;
        }
        int nc = this.curveIndex(pos);
        if ((double)nc - Math.floor(pos / 2.0) > 0.0) {
            return true;
        }
        Curve2D curve = (Curve2D)this.curves.get(nc);
        return curve.isSingular(this.localPosition(pos));
    }

    @Override
    public double position(Point2D point) {
        double minDist;
        double dist = minDist = Double.MAX_VALUE;
        double x = point.x();
        double y = point.y();
        double pos = 0.0;
        int i = 0;
        for (Curve2D curve : this.curves) {
            dist = curve.distance(x, y);
            if (dist < minDist) {
                minDist = dist;
                pos = curve.position(point);
                double t0 = curve.t0();
                double t1 = curve.t1();
                pos = Curves2D.toUnitSegment(pos, t0, t1) + (double)(i * 2);
            }
            ++i;
        }
        return pos;
    }

    @Override
    public double project(Point2D point) {
        double minDist;
        double dist = minDist = Double.MAX_VALUE;
        double x = point.x();
        double y = point.y();
        double pos = 0.0;
        int i = 0;
        for (Curve2D curve : this.curves) {
            dist = curve.distance(x, y);
            if (dist < minDist) {
                minDist = dist;
                pos = curve.project(point);
                double t0 = curve.t0();
                double t1 = curve.t1();
                pos = Curves2D.toUnitSegment(pos, t0, t1) + (double)(i * 2);
            }
            ++i;
        }
        return pos;
    }

    @Override
    public Curve2D reverse() {
        int n = this.curves.size();
        Curve2D[] curves2 = new Curve2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = ((Curve2D)this.curves.get(n - 1 - i)).reverse();
            ++i;
        }
        return new CurveArray2D(curves2);
    }

    @Override
    public CurveSet2D<? extends Curve2D> subCurve(double t0, double t1) {
        int nc = this.curves.size();
        CurveArray2D<Curve2D> res = new CurveArray2D<Curve2D>();
        t0 = Math.min(Math.max(t0, 0.0), (double)(nc * 2) - 0.6);
        t1 = Math.min(Math.max(t1, 0.0), (double)(nc * 2) - 0.6);
        double t0f = Math.floor(t0);
        double t1f = Math.floor(t1);
        int ind0 = (int)Math.floor(t0f / 2.0);
        int ind1 = (int)Math.floor(t1f / 2.0);
        if (t0 - (double)(2 * ind0) > 1.5) {
            ++ind0;
        }
        if (t1 - (double)(2 * ind1) > 1.5) {
            ++ind1;
        }
        t0f = 2 * ind0;
        t1f = 2 * ind1;
        if (ind0 == ind1 && t0 < t1) {
            Curve2D curve = (Curve2D)this.curves.get(ind0);
            double pos0 = Curves2D.fromUnitSegment(t0 - t0f, curve.t0(), curve.t1());
            double pos1 = Curves2D.fromUnitSegment(t1 - t1f, curve.t0(), curve.t1());
            res.add(curve.subCurve(pos0, pos1));
            return res;
        }
        Curve2D curve = (Curve2D)this.curves.get(ind0);
        double pos0 = Curves2D.fromUnitSegment(t0 - t0f, curve.t0(), curve.t1());
        res.add(curve.subCurve(pos0, curve.t1()));
        if (ind1 > ind0) {
            int n = ind0 + 1;
            while (n < ind1) {
                res.add((Curve2D)this.curves.get(n));
                ++n;
            }
        } else {
            int n = ind0 + 1;
            while (n < nc) {
                res.add((Curve2D)this.curves.get(n));
                ++n;
            }
            n = 0;
            while (n < ind1) {
                res.add((Curve2D)this.curves.get(n));
                ++n;
            }
        }
        curve = (Curve2D)this.curves.get(ind1);
        double pos1 = Curves2D.fromUnitSegment(t1 - t1f, curve.t0(), curve.t1());
        res.add(curve.subCurve(curve.t0(), pos1));
        return res;
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        double dist = Double.POSITIVE_INFINITY;
        for (Curve2D curve : this.curves) {
            dist = Math.min(dist, curve.distance(x, y));
        }
        return dist;
    }

    @Override
    public boolean isBounded() {
        for (Curve2D curve : this.curves) {
            if (curve.isBounded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CurveSet2D<? extends Curve2D> clip(Box2D box) {
        return Curves2D.clipCurveSet(this, box);
    }

    @Override
    public Box2D boundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Curve2D curve : this.curves) {
            Box2D box = curve.boundingBox();
            xmin = Math.min(xmin, box.getMinX());
            ymin = Math.min(ymin, box.getMinY());
            xmax = Math.max(xmax, box.getMaxX());
            ymax = Math.max(ymax, box.getMaxY());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public CurveArray2D<? extends Curve2D> transform(AffineTransform2D trans) {
        CurveArray2D<Curve2D> result = new CurveArray2D<Curve2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            result.add(curve.transform(trans));
        }
        return result;
    }

    @Override
    public Collection<? extends ContinuousCurve2D> continuousCurves() {
        ArrayList<? extends ContinuousCurve2D> continuousCurves = new ArrayList<ContinuousCurve2D>();
        for (Curve2D curve : this.curves) {
            if (curve instanceof ContinuousCurve2D) {
                continuousCurves.add((ContinuousCurve2D)curve);
                continue;
            }
            continuousCurves.addAll(curve.continuousCurves());
        }
        return continuousCurves;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(double x, double y) {
        for (Curve2D curve : this.curves) {
            if (!curve.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.curves.size() == 0) {
            return path;
        }
        for (ContinuousCurve2D curve : this.continuousCurves()) {
            Point2D point = curve.firstPoint();
            path.moveTo((float)point.x(), (float)point.y());
            path = curve.appendPath(path);
        }
        return path;
    }

    @Override
    public Shape asAwtShape() {
        return this.getGeneralPath();
    }

    @Override
    public void draw(Graphics2D g2) {
        for (Curve2D curve : this.curves) {
            curve.draw(g2);
        }
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CurveArray2D)) {
            return false;
        }
        CurveArray2D shapeSet = (CurveArray2D)obj;
        if (this.curves.size() != shapeSet.curves.size()) {
            return false;
        }
        int i = 0;
        while (i < this.curves.size()) {
            if (!((Curve2D)this.curves.get(i)).almostEquals((GeometricObject2D)shapeSet.curves.get(i), eps)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CurveArray2D)) {
            return false;
        }
        CurveArray2D curveSet = (CurveArray2D)obj;
        if (this.size() != curveSet.size()) {
            return false;
        }
        int i = 0;
        while (i < this.curves.size()) {
            if (!((Curve2D)this.curves.get(i)).equals(curveSet.curves.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @Deprecated
    public CurveArray2D<? extends Curve2D> clone() {
        ArrayList<Curve2D> array = new ArrayList<Curve2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            array.add(curve);
        }
        return new CurveArray2D(array);
    }

    @Override
    public Iterator<T> iterator() {
        return this.curves.iterator();
    }
}

