/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.PolyCurve2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.OrientedCurve2D;
import math.geom2d.line.StraightLine2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyOrientedCurve2D<T extends ContinuousOrientedCurve2D>
extends PolyCurve2D<T>
implements ContinuousOrientedCurve2D {
    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(Collection<T> curves) {
        return new PolyOrientedCurve2D<T>(curves);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(T ... curves) {
        return new PolyOrientedCurve2D(curves);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> createClosed(T ... curves) {
        return new PolyOrientedCurve2D(curves, true);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(Collection<T> curves, boolean closed) {
        return new PolyOrientedCurve2D<T>(curves, closed);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(T[] curves, boolean closed) {
        return new PolyOrientedCurve2D(curves, closed);
    }

    public PolyOrientedCurve2D() {
    }

    public PolyOrientedCurve2D(int size) {
        super(size);
    }

    public PolyOrientedCurve2D(T ... curves) {
        super(curves);
    }

    public PolyOrientedCurve2D(T[] curves, boolean closed) {
        super(curves, closed);
    }

    public PolyOrientedCurve2D(Collection<? extends T> curves) {
        super(curves);
    }

    public PolyOrientedCurve2D(Collection<? extends T> curves, boolean closed) {
        super(curves, closed);
    }

    @Override
    public double windingAngle(Point2D point) {
        double angle = 0.0;
        for (OrientedCurve2D curve : this.curves) {
            angle += curve.windingAngle(point);
        }
        return angle;
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        double dist = this.distance(x, y);
        if (this.isInside(new Point2D(x, y))) {
            dist = -dist;
        }
        return dist;
    }

    @Override
    public boolean isInside(Point2D point) {
        double eps;
        double pos = this.project(point);
        if (!this.isSingular(pos)) {
            return ((ContinuousOrientedCurve2D)this.childCurve(pos)).isInside(point);
        }
        int n = this.size();
        int i = this.curveIndex(pos);
        if (pos / 2.0 - (double)i > 0.25) {
            ++i;
        }
        if (Math.round(pos) == (long)(2 * n - 1)) {
            pos = 0.0;
            i = 0;
        }
        Point2D vertex = this.point(pos);
        int iPrev = i > 0 ? i - 1 : n - 1;
        int iNext = i;
        ContinuousOrientedCurve2D prev = (ContinuousOrientedCurve2D)this.curves.get(iPrev);
        ContinuousOrientedCurve2D next = (ContinuousOrientedCurve2D)this.curves.get(iNext);
        Vector2D v1 = PolyOrientedCurve2D.computeTangent(prev, prev.t1());
        Vector2D v2 = PolyOrientedCurve2D.computeTangent(next, next.t0());
        boolean in1 = new StraightLine2D(vertex, v1).isInside(point);
        boolean in2 = new StraightLine2D(vertex, v2).isInside(point);
        double diff = Angle2D.angle(v1, v2);
        if (diff < Math.PI - (eps = 1.0E-12)) {
            return in1 && in2;
        }
        if (diff > Math.PI + eps) {
            return in1 || in2;
        }
        SmoothCurve2D smoothPrev = Curves2D.getLastSmoothCurve(prev);
        SmoothCurve2D smoothNext = Curves2D.getFirstSmoothCurve(next);
        double kappaPrev = smoothPrev.curvature(smoothPrev.t1());
        double kappaNext = smoothNext.curvature(smoothNext.t0());
        double sp = Math.signum(kappaPrev);
        double sn = Math.signum(kappaNext);
        if (sn * sp > 0.0) {
            return kappaPrev > 0.0 && kappaNext > 0.0;
        }
        if (sn * sp == 0.0) {
            if (sn == 0.0 && sp == 0.0) {
                throw new IllegalArgumentException("colinear lines...");
            }
            if (sp == 0.0) {
                return kappaNext > 0.0;
            }
            return kappaPrev > 0.0;
        }
        if (kappaPrev > 0.0 && kappaNext < 0.0) {
            return Math.abs(kappaPrev) > Math.abs(kappaNext);
        }
        return Math.abs(kappaPrev) < Math.abs(kappaNext);
    }

    private static Vector2D computeTangent(ContinuousCurve2D curve, double pos) {
        if (curve instanceof SmoothCurve2D) {
            return ((SmoothCurve2D)curve).tangent(pos);
        }
        if (curve instanceof CurveSet2D) {
            CurveSet2D curveSet = (CurveSet2D)((Object)curve);
            double pos2 = curveSet.localPosition(pos);
            Object subCurve = curveSet.childCurve(pos);
            return PolyOrientedCurve2D.computeTangent((ContinuousCurve2D)subCurve, pos2);
        }
        throw new IllegalArgumentException("Unknown type of curve: should be either continuous or curveset");
    }

    @Override
    public PolyOrientedCurve2D<? extends ContinuousOrientedCurve2D> reverse() {
        ContinuousOrientedCurve2D[] curves2 = new ContinuousOrientedCurve2D[this.curves.size()];
        int n = this.curves.size();
        int i = 0;
        while (i < n) {
            curves2[i] = ((ContinuousOrientedCurve2D)this.curves.get(n - 1 - i)).reverse();
            ++i;
        }
        return new PolyOrientedCurve2D(curves2);
    }

    @Override
    public PolyOrientedCurve2D<? extends ContinuousOrientedCurve2D> subCurve(double t0, double t1) {
        Curve2D set = super.subCurve(t0, t1);
        PolyOrientedCurve2D<ContinuousOrientedCurve2D> subCurve = new PolyOrientedCurve2D<ContinuousOrientedCurve2D>();
        subCurve.setClosed(false);
        for (Curve2D curve : ((CurveArray2D)set).curves()) {
            subCurve.add((ContinuousOrientedCurve2D)curve);
        }
        return subCurve;
    }

    @Override
    public CurveSet2D<? extends ContinuousOrientedCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        int n = set.size();
        CurveArray2D<ContinuousOrientedCurve2D> result = new CurveArray2D<ContinuousOrientedCurve2D>(n);
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof ContinuousOrientedCurve2D)) continue;
            result.add((ContinuousOrientedCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public PolyOrientedCurve2D<? extends ContinuousOrientedCurve2D> transform(AffineTransform2D trans) {
        PolyOrientedCurve2D<ContinuousOrientedCurve2D> result = new PolyOrientedCurve2D<ContinuousOrientedCurve2D>();
        for (ContinuousOrientedCurve2D curve : this.curves) {
            result.add(curve.transform(trans));
        }
        result.setClosed(this.closed);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CurveSet2D)) {
            return false;
        }
        return super.equals(obj);
    }
}

