/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearElement2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line2D
extends AbstractSmoothCurve2D
implements LinearElement2D,
Cloneable {
    public Point2D p1;
    public Point2D p2;

    public static boolean intersects(Line2D line1, Line2D line2) {
        boolean b2;
        Point2D e1p1 = line1.firstPoint();
        Point2D e1p2 = line1.lastPoint();
        Point2D e2p1 = line2.firstPoint();
        Point2D e2p2 = line2.lastPoint();
        boolean b1 = Point2D.ccw(e1p1, e1p2, e2p1) * Point2D.ccw(e1p1, e1p2, e2p2) <= 0;
        boolean bl = b2 = Point2D.ccw(e2p1, e2p2, e1p1) * Point2D.ccw(e2p1, e2p2, e1p2) <= 0;
        return b1 && b2;
    }

    public Line2D(Point2D point1, Point2D point2) {
        this.p1 = point1;
        this.p2 = point2;
    }

    public Line2D(double x1, double y1, double x2, double y2) {
        this.p1 = new Point2D(x1, y1);
        this.p2 = new Point2D(x2, y2);
    }

    public Line2D(Line2D line) {
        this(line.getPoint1(), line.getPoint2());
    }

    @Deprecated
    public static Line2D create(Point2D p1, Point2D p2) {
        return new Line2D(p1, p2);
    }

    public Point2D getPoint1() {
        return this.p1;
    }

    public Point2D getPoint2() {
        return this.p2;
    }

    public double getX1() {
        return this.p1.x();
    }

    public double getY1() {
        return this.p1.y();
    }

    public double getX2() {
        return this.p2.x();
    }

    public double getY2() {
        return this.p2.y();
    }

    public Point2D getOtherPoint(Point2D point) {
        if (point.equals(this.p1)) {
            return this.p2;
        }
        if (point.equals(this.p2)) {
            return this.p1;
        }
        return null;
    }

    public void setPoint1(Point2D point) {
        this.p1 = point;
    }

    public void setPoint2(Point2D point) {
        this.p2 = point;
    }

    public boolean isColinear(LinearShape2D line) {
        return new LineSegment2D(this.p1, this.p2).isColinear(line);
    }

    public boolean isParallel(LinearShape2D line) {
        return new LineSegment2D(this.p1, this.p2).isParallel(line);
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public Line2D parallel(double d) {
        double x0 = this.getX1();
        double y0 = this.getY1();
        double dx = this.getX2() - x0;
        double dy = this.getY2() - y0;
        double d2 = d / Math.hypot(dx, dy);
        return new Line2D(x0 + dy * d2, y0 - dx * d2, x0 + dx + dy * d2, y0 + dy - dx * d2);
    }

    @Override
    public double length() {
        return this.p1.distance(this.p2);
    }

    @Override
    public double length(double pos) {
        double dx = this.p2.x() - this.p1.x();
        double dy = this.p2.y() - this.p1.y();
        return pos * Math.hypot(dx, dy);
    }

    @Override
    public double position(double length) {
        double dx = this.p2.x() - this.p1.x();
        double dy = this.p2.y() - this.p1.y();
        return length / Math.hypot(dx, dy);
    }

    @Override
    public CirculinearElement2D transform(CircleInversion2D inv) {
        Point2D center = inv.center();
        double r = inv.radius();
        Point2D po = new StraightLine2D(this).projectedPoint(center);
        double d = this.distance(po);
        if (Math.abs(d) < 1.0E-12) {
            Point2D p1 = this.firstPoint().transform(inv);
            Point2D p2 = this.lastPoint().transform(inv);
            return new LineSegment2D(p1, p2);
        }
        double angle = Angle2D.horizontalAngle(center, po);
        double r2 = r * r / d / 2.0;
        Point2D c2 = Point2D.createPolar(center, r2, angle);
        boolean direct = !this.isInside(center);
        double theta1 = Angle2D.horizontalAngle(c2, this.p1);
        double theta2 = Angle2D.horizontalAngle(c2, this.p2);
        return new CircleArc2D(c2, r2, theta1, theta2, direct);
    }

    public double[][] parametric() {
        return new LineSegment2D(this.p1, this.p2).parametric();
    }

    public double[] cartesianEquation() {
        return new LineSegment2D(this.p1, this.p2).cartesianEquation();
    }

    public double[] polarCoefficients() {
        return new LineSegment2D(this.p1, this.p2).polarCoefficients();
    }

    public double[] polarCoefficientsSigned() {
        return new LineSegment2D(this.p1, this.p2).polarCoefficientsSigned();
    }

    @Override
    public double horizontalAngle() {
        return new LineSegment2D(this.p1, this.p2).horizontalAngle();
    }

    @Override
    public Point2D intersection(LinearShape2D line) {
        return new LineSegment2D(this.p1, this.p2).intersection(line);
    }

    @Override
    public Point2D origin() {
        return this.p1;
    }

    @Override
    public StraightLine2D supportingLine() {
        return new StraightLine2D(this.p1, this.p2);
    }

    @Override
    public Vector2D direction() {
        return new Vector2D(this.p1, this.p2);
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        return new LineSegment2D(this.p1, this.p2).signedDistance(x, y);
    }

    public Collection<? extends Line2D> smoothPieces() {
        return Line2D.wrapCurve(this);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        StraightLine2D support = new StraightLine2D(this.p1, this.p2);
        Point2D proj = support.projectedPoint(x, y);
        if (this.contains(proj)) {
            return proj.distance(x, y);
        }
        double d1 = Math.hypot(this.p1.x() - x, this.p1.y() - y);
        double d2 = Math.hypot(this.p2.x() - x, this.p2.y() - y);
        return Math.min(d1, d2);
    }

    public StraightLine2D parallel(Point2D point) {
        return new LineSegment2D(this.p1, this.p2).parallel(point);
    }

    public StraightLine2D perpendicular(Point2D point) {
        return new LineSegment2D(this.p1, this.p2).perpendicular(point);
    }

    @Override
    public CurveSet2D<? extends Line2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        CurveArray2D<Line2D> result = new CurveArray2D<Line2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof Line2D)) continue;
            result.add((Line2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(this.p1, this.p2);
    }

    @Override
    public Vector2D tangent(double t) {
        return new Vector2D(this.p1, this.p2);
    }

    @Override
    public double curvature(double t) {
        return 0.0;
    }

    @Override
    public double windingAngle(Point2D point) {
        return new LineSegment2D(this.p1, this.p2).windingAngle(point);
    }

    @Override
    public boolean isInside(Point2D point) {
        return new LineSegment2D(this.p1, this.p2).signedDistance(point) < 0.0;
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return 1.0;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        t = Math.min(Math.max(t, 0.0), 1.0);
        double x = this.p1.x() * (1.0 - t) + this.p2.x() * t;
        double y = this.p1.y() * (1.0 - t) + this.p2.y() * t;
        return new Point2D(x, y);
    }

    @Override
    public Point2D firstPoint() {
        return this.p1;
    }

    @Override
    public Point2D lastPoint() {
        return this.p2;
    }

    @Override
    public double position(Point2D point) {
        return new LineSegment2D(this.p1, this.p2).position(point);
    }

    @Override
    public double project(Point2D point) {
        return new LineSegment2D(this.p1, this.p2).project(point);
    }

    @Override
    public Line2D reverse() {
        return new Line2D(this.p2, this.p1);
    }

    public Collection<? extends Line2D> continuousCurves() {
        return Line2D.wrapCurve(this);
    }

    @Override
    public Line2D subCurve(double t0, double t1) {
        if (t0 > t1) {
            return null;
        }
        t0 = Math.max(t0, this.t0());
        t1 = Math.min(t1, this.t1());
        return new Line2D(this.point(t0), this.point(t1));
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        return new LineSegment2D(this.p1, this.p2).intersections(line);
    }

    @Override
    public Line2D transform(AffineTransform2D trans) {
        return new Line2D(this.p1.transform(trans), this.p2.transform(trans));
    }

    @Override
    public boolean contains(double x, double y) {
        return new LineSegment2D(this.p1, this.p2).contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)this.p1.x(), (float)this.p1.y());
        path.lineTo((float)this.p2.x(), (float)this.p2.y());
        return path;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        path.lineTo((float)this.p2.x(), (float)this.p2.y());
        return path;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Line2D)) {
            return false;
        }
        Line2D edge = (Line2D)obj;
        return this.p1.almostEquals(edge.p1, eps) && this.p2.almostEquals(edge.p2, eps);
    }

    public String toString() {
        return "Line2D(" + this.p1 + ")-(" + this.p2 + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Line2D)) {
            return false;
        }
        Line2D edge = (Line2D)obj;
        return this.p1.equals(edge.p1) && this.p2.equals(edge.p2);
    }

    @Override
    @Deprecated
    public Line2D clone() {
        return new Line2D(this.p1, this.p2);
    }
}

