/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import com.seisw.util.geom.Poly;
import com.seisw.util.geom.PolyDefault;
import com.seisw.util.geom.PolySimple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.domain.Boundaries2D;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.point.PointSets2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.MultiPolygon2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.polygon.convhull.JarvisMarch2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Polygons2D {
    public static final SimplePolygon2D createRectangle(Point2D p1, Point2D p2) {
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        return Polygons2D.createRectangle(x1, y1, x2, y2);
    }

    public static final SimplePolygon2D createRectangle(double x1, double y1, double x2, double y2) {
        double xmin = Math.min(x1, x2);
        double xmax = Math.max(x1, x2);
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        return new SimplePolygon2D(new Point2D(xmin, ymin), new Point2D(xmax, ymin), new Point2D(xmax, ymax), new Point2D(xmin, ymax));
    }

    public static final SimplePolygon2D createCenteredRectangle(Point2D center, double length, double width) {
        double xc = center.x();
        double yc = center.y();
        double len = length / 2.0;
        double wid = width / 2.0;
        double x1 = xc - len;
        double y1 = yc - wid;
        double x2 = xc + len;
        double y2 = yc + wid;
        return new SimplePolygon2D(new Point2D(x1, y1), new Point2D(x2, y1), new Point2D(x2, y2), new Point2D(x1, y2));
    }

    public static final SimplePolygon2D createOrientedRectangle(Point2D center, double length, double width, double theta) {
        double xc = center.x();
        double yc = center.y();
        double len = length / 2.0;
        double wid = width / 2.0;
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new SimplePolygon2D(new Point2D(-len * cot + wid * sit + xc, -len * sit - wid * cot + yc), new Point2D(len * cot + wid * sit + xc, len * sit - wid * cot + yc), new Point2D(len * cot - wid * sit + xc, len * sit + wid * cot + yc), new Point2D(-len * cot - wid * sit + xc, -len * sit + wid * cot + yc));
    }

    public static final Point2D computeCentroid(Polygon2D polygon) {
        if (polygon instanceof SimplePolygon2D) {
            LinearRing2D ring = ((SimplePolygon2D)polygon).getRing();
            return Polygons2D.computeCentroid(ring);
        }
        double xc = 0.0;
        double yc = 0.0;
        double cumArea = 0.0;
        for (LinearRing2D linearRing2D : polygon.contours()) {
            double area = Polygons2D.computeArea(linearRing2D);
            Point2D centroid = Polygons2D.computeCentroid(linearRing2D);
            xc += centroid.x() * area;
            yc += centroid.y() * area;
            cumArea += area;
        }
        return new Point2D(xc /= cumArea, yc /= cumArea);
    }

    public static final Point2D computeCentroid(LinearRing2D ring) {
        double xc = 0.0;
        double yc = 0.0;
        double tmp = 0.0;
        int n = ring.vertexNumber();
        Point2D prev = ring.vertex(n - 1);
        double xp = prev.x();
        double yp = prev.y();
        for (Point2D point : ring.vertices()) {
            double x = point.x();
            double y = point.y();
            tmp = xp * y - yp * x;
            xc += (x + xp) * tmp;
            yc += (y + yp) * tmp;
            prev = point;
            xp = x;
            yp = y;
        }
        double denom = Polygons2D.computeArea(ring) * 6.0;
        return new Point2D(xc / denom, yc / denom);
    }

    public static final double computeArea(Polygon2D polygon) {
        double area = 0.0;
        for (LinearRing2D linearRing2D : polygon.contours()) {
            area += Polygons2D.computeArea(linearRing2D);
        }
        return area;
    }

    public static final double computeArea(LinearRing2D ring) {
        double area = 0.0;
        int n = ring.vertexNumber();
        Point2D prev = ring.vertex(n - 1);
        for (Point2D point : ring.vertices()) {
            area += prev.x() * point.y() - prev.y() * point.x();
            prev = point;
        }
        return area /= 2.0;
    }

    public static final int windingNumber(Collection<Point2D> vertices, Point2D point) {
        int wn = 0;
        Point2D previous = null;
        Iterator<Point2D> iterator = vertices.iterator();
        while (iterator.hasNext()) {
            Point2D vertex;
            previous = vertex = iterator.next();
        }
        double y1 = previous.y();
        double y = point.y();
        for (Point2D current : vertices) {
            double y2 = current.y();
            if (y1 <= y) {
                if (y2 > y && Polygons2D.isLeft(previous, current, point) > 0) {
                    ++wn;
                }
            } else if (y2 <= y && Polygons2D.isLeft(previous, current, point) < 0) {
                --wn;
            }
            y1 = y2;
            previous = current;
        }
        return wn;
    }

    private static final int isLeft(Point2D p1, Point2D p2, Point2D pt) {
        double x = p1.x();
        double y = p1.y();
        return (int)Math.signum((p2.x() - x) * (pt.y() - y) - (pt.x() - x) * (p2.y() - y));
    }

    public static final Polygon2D convexHull(Collection<? extends Point2D> points) {
        return new JarvisMarch2D().convexHull(points);
    }

    public static final CirculinearDomain2D createBuffer(Polygon2D polygon, double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(polygon.boundary(), dist);
    }

    public static final Polygon2D clipPolygon(Polygon2D polygon, Box2D box) {
        CirculinearContourArray2D<? extends LinearRing2D> boundary = polygon.boundary();
        ContourArray2D<Contour2D> contours = Boundaries2D.clipBoundary(boundary, box);
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>();
        for (Contour2D contour : contours) {
            rings.add(Polygons2D.convertContourToLinearRing(contour));
        }
        if (rings.size() == 1) {
            return SimplePolygon2D.create(rings.get(0).vertices());
        }
        return MultiPolygon2D.create(rings);
    }

    private static final LinearRing2D convertContourToLinearRing(Contour2D contour) {
        if (contour instanceof LinearRing2D) {
            return (LinearRing2D)contour;
        }
        List<Point2D> vertices = new ArrayList();
        for (Point2D v : contour.singularPoints()) {
            vertices.add(v);
        }
        vertices = PointSets2D.filterMultipleVertices(vertices, true);
        return LinearRing2D.create(vertices);
    }

    public static final Polygon2D union(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygons2D.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygons2D.convertToGpcjPolygon(polygon2);
        Poly result = poly1.union(poly2);
        return Polygons2D.convertFromGpcjPolygon(result);
    }

    public static final Polygon2D intersection(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygons2D.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygons2D.convertToGpcjPolygon(polygon2);
        Poly result = poly1.intersection(poly2);
        return Polygons2D.convertFromGpcjPolygon(result);
    }

    public static final Polygon2D exclusiveOr(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygons2D.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygons2D.convertToGpcjPolygon(polygon2);
        Poly result = poly1.xor(poly2);
        return Polygons2D.convertFromGpcjPolygon(result);
    }

    public static final Polygon2D difference(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygons2D.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygons2D.convertToGpcjPolygon(polygon2);
        Poly result = poly1.difference(poly2);
        return Polygons2D.convertFromGpcjPolygon(result);
    }

    private static final Poly convertToGpcjPolygon(Polygon2D polygon) {
        PolyDefault result = new PolyDefault();
        for (LinearRing2D linearRing2D : polygon.contours()) {
            result.add(Polygons2D.convertToGpcjSimplePolygon(linearRing2D));
        }
        return result;
    }

    private static final PolySimple convertToGpcjSimplePolygon(LinearRing2D ring) {
        PolySimple poly = new PolySimple();
        for (Point2D point : ring.vertices()) {
            poly.add(new com.seisw.util.geom.Point2D(point.x(), point.y()));
        }
        return poly;
    }

    private static final Polygon2D convertFromGpcjPolygon(Poly poly) {
        int n = poly.getNumInnerPoly();
        if (n == 1) {
            Point2D[] points = Polygons2D.extractPolyVertices(poly.getInnerPoly(0));
            return SimplePolygon2D.create(points);
        }
        LinearRing2D[] rings = new LinearRing2D[n];
        int i = 0;
        while (i < n) {
            rings[i] = Polygons2D.convertFromGpcjSimplePolygon(poly.getInnerPoly(i));
            ++i;
        }
        return MultiPolygon2D.create(rings);
    }

    private static final LinearRing2D convertFromGpcjSimplePolygon(Poly poly) {
        return LinearRing2D.create(Polygons2D.extractPolyVertices(poly));
    }

    private static final Point2D[] extractPolyVertices(Poly poly) {
        int n = poly.getNumPoints();
        Point2D[] points = new Point2D[n];
        int i = 0;
        while (i < n) {
            points[i] = new Point2D(poly.getX(i), poly.getY(i));
            ++i;
        }
        return points;
    }
}

