/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Point2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.point.PointSets2D;
import math.geom2d.polygon.LinearCurve2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Polylines2D {
    static ArrayList<Point2D> simplifyPolyline(ArrayList<Point2D> vertices, double distMax) {
        int last = vertices.size() - 1;
        int[] inds = Polylines2D.recurseSimplify(vertices, 0, last, distMax);
        ArrayList<Point2D> newVerts = new ArrayList<Point2D>(inds.length + 2);
        newVerts.add(vertices.get(0));
        int[] nArray = inds;
        int n = inds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            newVerts.add(vertices.get(i));
            ++n2;
        }
        newVerts.add(vertices.get(last));
        return newVerts;
    }

    static ArrayList<Point2D> simplifyClosedPolyline(ArrayList<Point2D> vertices, double distMax) {
        int nv = vertices.size();
        int indMax = 0;
        double maxDist = 0.0;
        Point2D p0 = vertices.get(0);
        int i = 1;
        while (i < vertices.size()) {
            double dist = vertices.get(i).distance(p0);
            if (dist > maxDist) {
                maxDist = dist;
                indMax = i;
            }
            ++i;
        }
        int[] inds1 = Polylines2D.recurseSimplify(vertices, 0, indMax, distMax);
        int[] inds2 = Polylines2D.recurseSimplify(vertices, indMax, nv, distMax);
        int[] inds = Polylines2D.concatInds(inds1, indMax, inds2);
        ArrayList<Point2D> newVerts = new ArrayList<Point2D>(inds.length + 2);
        newVerts.add(vertices.get(0));
        int[] nArray = inds;
        int n = inds.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            newVerts.add(vertices.get(i2));
            ++n2;
        }
        return newVerts;
    }

    private static int[] recurseSimplify(ArrayList<Point2D> vertices, int first, int last, double distMax) {
        if (last - first < 2) {
            return new int[0];
        }
        int nv = vertices.size();
        Point2D p0 = vertices.get(first);
        Point2D p1 = vertices.get(last % nv);
        LineSegment2D line = new LineSegment2D(p0, p1);
        double midDist = 0.0;
        int indMid = 0;
        int ind = first;
        while (ind < last) {
            double dist = line.distance(vertices.get(ind));
            if (dist > midDist) {
                midDist = dist;
                indMid = ind;
            }
            ++ind;
        }
        if (midDist < distMax) {
            return new int[0];
        }
        int[] inds1 = Polylines2D.recurseSimplify(vertices, first, indMid, distMax);
        int[] inds2 = Polylines2D.recurseSimplify(vertices, indMid, last, distMax);
        int[] res = Polylines2D.concatInds(inds1, indMid, inds2);
        return res;
    }

    private static int[] concatInds(int[] inds1, int indMid, int[] inds2) {
        int n = inds1.length + inds2.length + 1;
        int[] res = new int[n];
        int i = 0;
        while (i < inds1.length) {
            res[i] = inds1[i];
            ++i;
        }
        res[inds1.length] = indMid;
        i = inds1.length + 1;
        while (i < n) {
            res[i] = inds2[i - (inds1.length + 1)];
            ++i;
        }
        return res;
    }

    public static final boolean hasMultipleVertices(LinearCurve2D polyline) {
        return Polylines2D.hasMultipleVertices(polyline, false);
    }

    public static final boolean hasMultipleVertices(LinearCurve2D polyline, boolean closed) {
        Point2D p2;
        Point2D p1;
        if (PointSets2D.hasMultipleVertices(polyline.vertices)) {
            return true;
        }
        return closed && (p1 = polyline.firstPoint()).distance(p2 = polyline.lastPoint()) < 1.0E-12;
    }

    public static Collection<Point2D> intersect(LinearCurve2D poly1, LinearCurve2D poly2) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (LineSegment2D edge1 : poly1.edges()) {
            for (LineSegment2D edge2 : poly2.edges()) {
                Point2D point = edge1.intersection(edge2);
                if (point == null || points.contains(point)) continue;
                points.add(point);
            }
        }
        return points;
    }
}

