/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.spline;

import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.PolyCurve2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.spline.CubicBezierCurve2D;
import math.geom2d.spline.QuadBezierCurve2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralPath2D
implements Curve2D {
    ArrayList<Segment> segments;
    Type lastType = Type.CLOSE;

    public GeneralPath2D() {
        this.segments = new ArrayList();
    }

    public GeneralPath2D(GeneralPath2D path) {
        this.segments = new ArrayList(path.segments.size());
        for (Segment seg : path.segments) {
            switch (seg.type()) {
                case MOVE: {
                    Point2D[] pts = seg.controlPoints();
                    this.moveTo(pts[0]);
                    break;
                }
                case LINE: {
                    Point2D[] pts = seg.controlPoints();
                    this.lineTo(pts[0]);
                    break;
                }
                case QUAD: {
                    Point2D[] pts = seg.controlPoints();
                    this.quadTo(pts[0], pts[1]);
                    break;
                }
                case CUBIC: {
                    Point2D[] pts = seg.controlPoints();
                    this.cubicTo(pts[0], pts[1], pts[2]);
                    break;
                }
                case CLOSE: {
                    this.closePath();
                }
            }
        }
    }

    public void moveTo(Point2D p) {
        this.segments.add(new MoveSegment(p));
        this.lastType = Type.MOVE;
    }

    public void lineTo(Point2D p) {
        this.segments.add(new LinearSegment(p));
        this.lastType = Type.LINE;
    }

    public void quadTo(Point2D p1, Point2D p2) {
        this.segments.add(new QuadSegment(p1, p2));
        this.lastType = Type.QUAD;
    }

    public void cubicTo(Point2D p1, Point2D p2, Point2D p3) {
        this.segments.add(new CubicSegment(p1, p2, p3));
        this.lastType = Type.CUBIC;
    }

    public void closePath() {
        if (this.lastType == Type.CLOSE) {
            return;
        }
        this.segments.add(new ClosingSegment());
    }

    private Collection<SmoothCurve2D> smoothCurves() {
        Point2D lastControl = null;
        Point2D lastStart = null;
        int n = this.segments.size();
        ArrayList<SmoothCurve2D> curves = new ArrayList<SmoothCurve2D>(n);
        for (Segment seg : this.segments) {
            switch (seg.type()) {
                case MOVE: {
                    lastControl = lastStart = seg.lastControl();
                    break;
                }
                case LINE: {
                    Point2D[] pts = seg.controlPoints();
                    curves.add(new LineSegment2D(lastControl, pts[0]));
                    lastControl = pts[0];
                    break;
                }
                case QUAD: {
                    Point2D[] pts = seg.controlPoints();
                    curves.add(new QuadBezierCurve2D(lastControl, pts[0], pts[1]));
                    lastControl = pts[1];
                    break;
                }
                case CUBIC: {
                    Point2D[] pts = seg.controlPoints();
                    curves.add(new CubicBezierCurve2D(lastControl, pts[0], pts[1], pts[2]));
                    lastControl = pts[2];
                    break;
                }
                case CLOSE: {
                    curves.add(new LineSegment2D(lastControl, lastStart));
                    lastControl = lastStart;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
        }
        return curves;
    }

    private SmoothCurve2D segmentCurve(int index) {
        int n = this.segments.size();
        if (index > n - 2) {
            throw new IllegalArgumentException("Index must be lower than segment number");
        }
        AbstractSmoothCurve2D curve = null;
        Point2D lastControl = null;
        Point2D lastStart = null;
        int i = 0;
        while (i < index + 2) {
            Segment seg = this.segments.get(i);
            switch (seg.type()) {
                case MOVE: {
                    lastControl = lastStart = seg.lastControl();
                    break;
                }
                case LINE: {
                    Point2D[] pts = seg.controlPoints();
                    curve = new LineSegment2D(lastControl, pts[0]);
                    lastControl = pts[0];
                    break;
                }
                case QUAD: {
                    Point2D[] pts = seg.controlPoints();
                    curve = new QuadBezierCurve2D(lastControl, pts[0], pts[1]);
                    lastControl = pts[1];
                    break;
                }
                case CUBIC: {
                    Point2D[] pts = seg.controlPoints();
                    curve = new CubicBezierCurve2D(lastControl, pts[0], pts[1], pts[2]);
                    lastControl = pts[2];
                    break;
                }
                case CLOSE: {
                    curve = new LineSegment2D(lastControl, lastStart);
                    lastControl = lastStart;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
            ++i;
        }
        return curve;
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double t1() {
        return this.segments.size() - 1;
    }

    @Override
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        int index = (int)Math.floor(t);
        if (index == this.segments.size() - 1 && Math.abs(t - (double)index) < 1.0E-12) {
            return this.lastPoint();
        }
        SmoothCurve2D curve = this.segmentCurve(index);
        if (curve == null) {
            throw new RuntimeException("Can not manage position for MOVE Path segments");
        }
        double t0 = curve.t0();
        double t1 = curve.t1();
        double t2 = (t - (double)index) * (t1 - t0) + t0;
        return curve.point(t2);
    }

    @Override
    public Point2D firstPoint() {
        if (this.segments.isEmpty()) {
            return null;
        }
        return this.segments.get(0).controlPoints()[0];
    }

    @Override
    public Point2D lastPoint() {
        int n = this.segments.size();
        if (n == 0) {
            return null;
        }
        return this.segments.get(n - 1).lastControl();
    }

    @Override
    public Collection<Point2D> singularPoints() {
        ArrayList<Point2D> points = new ArrayList<Point2D>(this.segments.size());
        for (Segment seg : this.segments) {
            Point2D p = seg.lastControl();
            if (p == null) continue;
            points.add(p);
        }
        return points;
    }

    @Override
    public Collection<Point2D> vertices() {
        ArrayList<Point2D> vertices = new ArrayList<Point2D>(this.segments.size());
        for (Segment seg : this.segments) {
            Point2D[] point2DArray = seg.controlPoints();
            int n = point2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D p = point2DArray[n2];
                vertices.add(p);
                ++n2;
            }
        }
        return vertices;
    }

    @Override
    public boolean isSingular(double pos) {
        return Math.abs(pos - (double)Math.round(pos)) < 1.0E-12;
    }

    @Override
    public double position(Point2D point) {
        return this.project(point);
    }

    @Override
    public double project(Point2D point) {
        int index = -1;
        double pos = Double.NaN;
        double minDist = Double.MAX_VALUE;
        Point2D lastControl = null;
        Point2D lastStart = null;
        int n = this.segments.size();
        int i = 0;
        while (i < n) {
            block9: {
                AbstractSmoothCurve2D curve;
                Segment seg = this.segments.get(i);
                switch (seg.type()) {
                    case MOVE: {
                        lastControl = lastStart = seg.lastControl();
                        break block9;
                    }
                    case LINE: {
                        Point2D[] pts = seg.controlPoints();
                        curve = new LineSegment2D(lastControl, pts[0]);
                        lastControl = pts[0];
                        break;
                    }
                    case QUAD: {
                        Point2D[] pts = seg.controlPoints();
                        curve = new QuadBezierCurve2D(lastControl, pts[0], pts[1]);
                        lastControl = pts[1];
                        break;
                    }
                    case CUBIC: {
                        Point2D[] pts = seg.controlPoints();
                        curve = new CubicBezierCurve2D(lastControl, pts[0], pts[1], pts[2]);
                        lastControl = pts[2];
                        break;
                    }
                    case CLOSE: {
                        curve = new LineSegment2D(lastControl, lastStart);
                        lastControl = lastStart;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                    }
                }
                double dist = curve.distance(point);
                if (dist < minDist) {
                    minDist = dist;
                    index = i - 1;
                    pos = (double)index + curve.position(point);
                }
            }
            ++i;
        }
        return pos;
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        for (SmoothCurve2D curve : this.smoothCurves()) {
            pts.addAll(curve.intersections(line));
        }
        return pts;
    }

    @Override
    public Curve2D reverse() {
        ArrayList<ContinuousCurve2D> list = this.splitContinuousCurves();
        Collections.reverse(list);
        return new CurveArray2D<ContinuousCurve2D>((Collection<ContinuousCurve2D>)list);
    }

    @Override
    public Collection<? extends ContinuousCurve2D> continuousCurves() {
        return this.splitContinuousCurves();
    }

    private ArrayList<ContinuousCurve2D> splitContinuousCurves() {
        Point2D lastControl = null;
        Point2D lastStart = null;
        int n = this.segments.size();
        ArrayList<ContinuousCurve2D> curveList = new ArrayList<ContinuousCurve2D>(n);
        PolyCurve2D<AbstractSmoothCurve2D> curve = null;
        for (Segment seg : this.segments) {
            switch (seg.type()) {
                case MOVE: {
                    if (curve != null) {
                        curveList.add(curve);
                    }
                    curve = new PolyCurve2D<AbstractSmoothCurve2D>();
                    lastControl = lastStart = seg.lastControl();
                    break;
                }
                case LINE: {
                    Point2D[] pts = seg.controlPoints();
                    curve.add(new LineSegment2D(lastControl, pts[0]));
                    lastControl = pts[0];
                    break;
                }
                case QUAD: {
                    Point2D[] pts = seg.controlPoints();
                    curve.add(new QuadBezierCurve2D(lastControl, pts[0], pts[1]));
                    lastControl = pts[1];
                    break;
                }
                case CUBIC: {
                    Point2D[] pts = seg.controlPoints();
                    curve.add(new CubicBezierCurve2D(lastControl, pts[0], pts[1], pts[2]));
                    lastControl = pts[2];
                    break;
                }
                case CLOSE: {
                    curve.add(new LineSegment2D(lastControl, lastStart));
                    curve.setClosed(true);
                    curveList.add(curve);
                    curve = new PolyCurve2D();
                    lastControl = lastStart;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
        }
        return curveList;
    }

    @Override
    public Curve2D subCurve(double t0, double t1) {
        return null;
    }

    @Override
    public Path2D asAwtShape() {
        Path2D.Double path = new Path2D.Double();
        for (Segment seg : this.segments) {
            seg.updatePath(path);
        }
        return path;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(double x, double y) {
        Point2D lastControl = null;
        Point2D lastStart = null;
        for (Segment seg : this.segments) {
            switch (seg.type()) {
                case MOVE: {
                    lastControl = lastStart = seg.lastControl();
                    break;
                }
                case LINE: 
                case QUAD: 
                case CUBIC: {
                    if (seg.asCurve(lastControl, lastStart).contains(x, y)) {
                        return true;
                    }
                    lastControl = seg.lastControl();
                    break;
                }
                case CLOSE: {
                    if (seg.asCurve(lastControl, lastStart).contains(x, y)) {
                        return true;
                    }
                    lastControl = lastStart;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
        }
        return false;
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        double minDist = Double.MAX_VALUE;
        Point2D lastControl = null;
        Point2D lastStart = null;
        for (Segment seg : this.segments) {
            switch (seg.type()) {
                case MOVE: {
                    lastControl = lastStart = seg.lastControl();
                    break;
                }
                case LINE: 
                case QUAD: 
                case CUBIC: {
                    double dist = seg.asCurve(lastControl, lastStart).distance(x, y);
                    minDist = Math.min(dist, minDist);
                    lastControl = seg.lastControl();
                    break;
                }
                case CLOSE: {
                    double dist = seg.asCurve(lastControl, lastStart).distance(x, y);
                    minDist = Math.min(dist, minDist);
                    lastControl = lastStart;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
        }
        return minDist;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.segments.size() > 0;
    }

    @Override
    public Box2D boundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Segment seg : this.segments) {
            Point2D[] point2DArray = seg.controlPoints();
            int n = point2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D p = point2DArray[n2];
                double x = p.x();
                double y = p.y();
                xmin = Math.min(xmin, x);
                ymin = Math.min(ymin, y);
                xmax = Math.max(xmax, x);
                ymax = Math.max(ymax, y);
                ++n2;
            }
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public CurveSet2D<? extends Curve2D> clip(Box2D box) {
        ArrayList<ContinuousCurve2D> list = this.splitContinuousCurves();
        CurveArray2D<ContinuousCurve2D> curve = new CurveArray2D<ContinuousCurve2D>((Collection<ContinuousCurve2D>)list);
        return curve.clip(box);
    }

    @Override
    public Curve2D transform(AffineTransform2D trans) {
        GeneralPath2D path = new GeneralPath2D();
        for (Segment seg : this.segments) {
            switch (seg.type()) {
                case MOVE: {
                    path.moveTo(seg.lastControl().transform(trans));
                    break;
                }
                case LINE: {
                    path.lineTo(seg.lastControl().transform(trans));
                    break;
                }
                case QUAD: {
                    Point2D[] pts = seg.controlPoints();
                    path.quadTo(pts[0].transform(trans), pts[1].transform(trans));
                    break;
                }
                case CUBIC: {
                    Point2D[] pts = seg.controlPoints();
                    path.cubicTo(pts[0].transform(trans), pts[1].transform(trans), pts[2].transform(trans));
                    break;
                }
                case CLOSE: {
                    path.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
        }
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        Path2D path = this.asAwtShape();
        g2.draw(path);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneralPath2D)) {
            return false;
        }
        GeneralPath2D that = (GeneralPath2D)obj;
        if (this.segments.size() != that.segments.size()) {
            return false;
        }
        int i = 0;
        while (i < this.segments.size()) {
            Point2D[] pts2;
            Segment seg1 = this.segments.get(i);
            Segment seg2 = that.segments.get(i);
            if (seg1.type() != seg2.type()) {
                return false;
            }
            Point2D[] pts1 = seg1.controlPoints();
            if (pts1.length != (pts2 = seg2.controlPoints()).length) {
                throw new RuntimeException("Two path segments have type but different number of control points");
            }
            int j = 0;
            while (j < pts1.length) {
                if (!pts1[j].almostEquals(pts2[j], eps)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneralPath2D)) {
            return false;
        }
        GeneralPath2D that = (GeneralPath2D)obj;
        if (this.segments.size() != that.segments.size()) {
            return false;
        }
        int i = 0;
        while (i < this.segments.size()) {
            Point2D[] pts2;
            Segment seg1 = this.segments.get(i);
            Segment seg2 = that.segments.get(i);
            if (seg1.type() != seg2.type()) {
                return false;
            }
            Point2D[] pts1 = seg1.controlPoints();
            if (pts1.length != (pts2 = seg2.controlPoints()).length) {
                throw new RuntimeException("Two path segments have type but different number of control points");
            }
            int j = 0;
            while (j < pts1.length) {
                if (!pts1[j].equals(pts2[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public GeneralPath2D clone() {
        GeneralPath2D path = new GeneralPath2D();
        for (Segment seg : this.segments) {
            switch (seg.type()) {
                case MOVE: {
                    Point2D[] pts = seg.controlPoints();
                    path.moveTo(pts[0]);
                    break;
                }
                case LINE: {
                    Point2D[] pts = seg.controlPoints();
                    path.lineTo(pts[0]);
                    break;
                }
                case QUAD: {
                    Point2D[] pts = seg.controlPoints();
                    path.quadTo(pts[0], pts[1]);
                    break;
                }
                case CUBIC: {
                    Point2D[] pts = seg.controlPoints();
                    path.cubicTo(pts[0], pts[1], pts[2]);
                    break;
                }
                case CLOSE: {
                    path.closePath();
                }
                default: {
                    throw new RuntimeException("Unknown Path segment type: " + (Object)((Object)seg.type()));
                }
            }
        }
        return path;
    }

    private class ClosingSegment
    implements Segment {
        public Point2D[] controlPoints() {
            return new Point2D[0];
        }

        public Type type() {
            return Type.CLOSE;
        }

        public SmoothCurve2D asCurve(Point2D lastControl, Point2D lastStart) {
            return new LineSegment2D(lastControl, lastStart);
        }

        public Point2D lastControl() {
            return null;
        }

        public void updatePath(Path2D path) {
            path.closePath();
        }
    }

    private class CubicSegment
    implements Segment {
        Point2D p1;
        Point2D p2;
        Point2D p3;

        public CubicSegment(Point2D p1, Point2D p2, Point2D p3) {
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        public Point2D[] controlPoints() {
            return new Point2D[]{this.p1, this.p2, this.p3};
        }

        public Type type() {
            return Type.CUBIC;
        }

        public SmoothCurve2D asCurve(Point2D lastControl, Point2D lastStart) {
            return new CubicBezierCurve2D(lastControl, this.p1, this.p2, this.p3);
        }

        public Point2D lastControl() {
            return this.p3;
        }

        public void updatePath(Path2D path) {
            path.curveTo(this.p1.x(), this.p1.y(), this.p2.x(), this.p2.y(), this.p3.x(), this.p3.y());
        }
    }

    private class LinearSegment
    implements Segment {
        Point2D p;

        public LinearSegment(Point2D p) {
            this.p = p;
        }

        public Point2D[] controlPoints() {
            return new Point2D[]{this.p};
        }

        public Type type() {
            return Type.LINE;
        }

        public SmoothCurve2D asCurve(Point2D lastControl, Point2D lastStart) {
            return new LineSegment2D(lastControl, this.p);
        }

        public Point2D lastControl() {
            return this.p;
        }

        public void updatePath(Path2D path) {
            path.lineTo(this.p.x(), this.p.y());
        }
    }

    private class MoveSegment
    implements Segment {
        Point2D p;

        public MoveSegment(Point2D p) {
            this.p = p;
        }

        public Point2D[] controlPoints() {
            return new Point2D[]{this.p};
        }

        public Type type() {
            return Type.MOVE;
        }

        public SmoothCurve2D asCurve(Point2D lastControl, Point2D lastStart) {
            return null;
        }

        public Point2D lastControl() {
            return this.p;
        }

        public void updatePath(Path2D path) {
            path.moveTo(this.p.x(), this.p.y());
        }
    }

    private class QuadSegment
    implements Segment {
        Point2D p1;
        Point2D p2;

        public QuadSegment(Point2D p1, Point2D p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public Point2D[] controlPoints() {
            return new Point2D[]{this.p1, this.p2};
        }

        public Type type() {
            return Type.QUAD;
        }

        public SmoothCurve2D asCurve(Point2D lastControl, Point2D lastStart) {
            return new QuadBezierCurve2D(lastControl, this.p1, this.p2);
        }

        public Point2D lastControl() {
            return this.p2;
        }

        public void updatePath(Path2D path) {
            path.quadTo(this.p1.x(), this.p1.y(), this.p2.x(), this.p2.y());
        }
    }

    private static interface Segment {
        public Type type();

        public Point2D[] controlPoints();

        public SmoothCurve2D asCurve(Point2D var1, Point2D var2);

        public Point2D lastControl();

        public void updatePath(Path2D var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        MOVE,
        LINE,
        QUAD,
        CUBIC,
        CLOSE;

    }
}

