/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.transform.AffineTransform3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSet3D
implements Shape3D,
Iterable<Point3D> {
    protected Collection<Point3D> points = new ArrayList<Point3D>();

    public PointSet3D() {
    }

    public PointSet3D(int n) {
        this.points = new ArrayList<Point3D>(n);
    }

    public PointSet3D(Point3D[] points) {
        Point3D[] point3DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point3D element = point3DArray[n2];
            this.points.add(element);
            ++n2;
        }
    }

    public PointSet3D(Collection<? extends Point3D> points) {
        for (Point3D point3D : points) {
            this.points.add(point3D);
        }
    }

    public void addPoint(Point3D point) {
        this.points.add(point);
    }

    public void addPoints(Point3D[] points) {
        Point3D[] point3DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point3D element = point3DArray[n2];
            this.addPoint(element);
            ++n2;
        }
    }

    public void addPoints(Collection<Point3D> points) {
        this.points.addAll(points);
    }

    public Iterator<Point3D> getPoints() {
        return this.points.iterator();
    }

    public void clearPoints() {
        this.points.clear();
    }

    public int pointNumber() {
        return this.points.size();
    }

    @Override
    public Shape3D clip(Box3D box) {
        PointSet3D res = new PointSet3D(this.points.size());
        for (Point3D point : this.points) {
            PointSet3D clipped = point.clip(box);
            if (clipped == null) continue;
            res.addPoint(point);
        }
        return res;
    }

    @Override
    public Box3D boundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double zmin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        double zmax = Double.MIN_VALUE;
        for (Point3D point : this.points) {
            xmin = Math.min(xmin, point.getX());
            ymin = Math.min(ymin, point.getY());
            zmin = Math.min(zmin, point.getZ());
            xmax = Math.max(xmax, point.getX());
            ymax = Math.max(ymax, point.getY());
            zmax = Math.max(zmax, point.getZ());
        }
        return new Box3D(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    @Override
    public double distance(Point3D p) {
        if (this.points.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double dist = Double.POSITIVE_INFINITY;
        for (Point3D point : this.points) {
            dist = Math.min(dist, point.distance(p));
        }
        return dist;
    }

    @Override
    public boolean contains(Point3D point) {
        for (Point3D p : this.points) {
            if (!(point.distance(p) < 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public Shape3D transform(AffineTransform3D trans) {
        PointSet3D res = new PointSet3D();
        for (Point3D point : this.points) {
            res.addPoint(point.transform(trans));
        }
        return res;
    }

    @Override
    public Iterator<Point3D> iterator() {
        return this.points.iterator();
    }
}

