/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.transform;

import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.transform.Bijection3D;

public class AffineTransform3D
implements Bijection3D {
    protected double m00;
    protected double m01;
    protected double m02;
    protected double m03;
    protected double m10;
    protected double m11;
    protected double m12;
    protected double m13;
    protected double m20;
    protected double m21;
    protected double m22;
    protected double m23;

    public static final AffineTransform3D createTranslation(Vector3D vec) {
        return AffineTransform3D.createTranslation(vec.getX(), vec.getY(), vec.getZ());
    }

    public static final AffineTransform3D createTranslation(double x, double y, double z) {
        return new AffineTransform3D(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z);
    }

    public static final AffineTransform3D createRotationOx(double theta) {
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new AffineTransform3D(1.0, 0.0, 0.0, 0.0, 0.0, cot, -sit, 0.0, 0.0, sit, cot, 0.0);
    }

    public static final AffineTransform3D createRotationOy(double theta) {
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new AffineTransform3D(cot, 0.0, sit, 0.0, 0.0, 1.0, 0.0, 0.0, -sit, 0.0, cot, 0.0);
    }

    public static final AffineTransform3D createRotationOz(double theta) {
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new AffineTransform3D(cot, -sit, 0.0, 0.0, sit, cot, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public static final AffineTransform3D createScaling(double s) {
        return AffineTransform3D.createScaling(s, s, s);
    }

    public static final AffineTransform3D createScaling(double sx, double sy, double sz) {
        return new AffineTransform3D(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0);
    }

    public AffineTransform3D() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
    }

    public AffineTransform3D(double[] coefs) {
        if (coefs.length == 9) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m10 = coefs[3];
            this.m11 = coefs[4];
            this.m12 = coefs[5];
            this.m20 = coefs[6];
            this.m21 = coefs[7];
            this.m22 = coefs[8];
        } else if (coefs.length == 12) {
            this.m00 = coefs[0];
            this.m01 = coefs[1];
            this.m02 = coefs[2];
            this.m03 = coefs[3];
            this.m10 = coefs[4];
            this.m11 = coefs[5];
            this.m12 = coefs[6];
            this.m13 = coefs[7];
            this.m20 = coefs[8];
            this.m21 = coefs[9];
            this.m22 = coefs[10];
            this.m23 = coefs[11];
        }
    }

    public AffineTransform3D(double xx, double yx, double zx, double tx, double xy, double yy, double zy, double ty, double xz, double yz, double zz, double tz) {
        this.m00 = xx;
        this.m01 = yx;
        this.m02 = zx;
        this.m03 = tx;
        this.m10 = xy;
        this.m11 = yy;
        this.m12 = zy;
        this.m13 = ty;
        this.m20 = xz;
        this.m21 = yz;
        this.m22 = zz;
        this.m23 = tz;
    }

    public boolean isIdentity() {
        if (this.m00 != 1.0) {
            return false;
        }
        if (this.m11 != 1.0) {
            return false;
        }
        if (this.m22 != 0.0) {
            return false;
        }
        if (this.m01 != 0.0) {
            return false;
        }
        if (this.m02 != 0.0) {
            return false;
        }
        if (this.m03 != 0.0) {
            return false;
        }
        if (this.m10 != 0.0) {
            return false;
        }
        if (this.m12 != 0.0) {
            return false;
        }
        if (this.m13 != 0.0) {
            return false;
        }
        if (this.m20 != 0.0) {
            return false;
        }
        if (this.m21 != 0.0) {
            return false;
        }
        return this.m23 == 0.0;
    }

    public double[] coefficients() {
        double[] tab = new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23};
        return tab;
    }

    private double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    }

    public AffineTransform3D inverse() {
        double det = this.determinant();
        return new AffineTransform3D((this.m11 * this.m22 - this.m21 * this.m12) / det, (this.m21 * this.m01 - this.m01 * this.m22) / det, (this.m01 * this.m12 - this.m11 * this.m02) / det, (this.m01 * (this.m22 * this.m13 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m21 * this.m13) - this.m03 * (this.m11 * this.m22 - this.m21 * this.m12)) / det, (this.m20 * this.m12 - this.m10 * this.m22) / det, (this.m00 * this.m22 - this.m20 * this.m02) / det, (this.m10 * this.m02 - this.m00 * this.m12) / det, (this.m00 * (this.m12 * this.m23 - this.m22 * this.m13) - this.m02 * (this.m10 * this.m23 - this.m20 * this.m13) + this.m03 * (this.m10 * this.m22 - this.m20 * this.m12)) / det, (this.m10 * this.m21 - this.m20 * this.m11) / det, (this.m20 * this.m01 - this.m00 * this.m21) / det, (this.m00 * this.m11 - this.m10 * this.m01) / det, (this.m00 * (this.m21 * this.m13 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m20 * this.m13) - this.m03 * (this.m10 * this.m21 - this.m20 * this.m11)) / det);
    }

    public void transform(AffineTransform3D trans) {
        double n00 = this.m00 * trans.m00 + this.m10 * trans.m01;
        double n10 = this.m00 * trans.m10 + this.m10 * trans.m11;
        double n01 = this.m01 * trans.m00 + this.m11 * trans.m01;
        double n11 = this.m01 * trans.m10 + this.m11 * trans.m11;
        double n02 = this.m02 * trans.m00 + this.m12 * trans.m01 + trans.m02;
        double n12 = this.m02 * trans.m10 + this.m12 * trans.m11 + trans.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
    }

    public void preConcatenate(AffineTransform3D trans) {
        double n00 = trans.m00 * this.m00 + trans.m10 * this.m01;
        double n10 = trans.m00 * this.m10 + trans.m10 * this.m11;
        double n01 = trans.m01 * this.m00 + trans.m11 * this.m01;
        double n11 = trans.m01 * this.m10 + trans.m11 * this.m11;
        double n02 = trans.m02 * this.m00 + trans.m12 * this.m01 + this.m02;
        double n12 = trans.m02 * this.m10 + trans.m12 * this.m11 + this.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
    }

    public Point3D[] transformPoints(Point3D[] src, Point3D[] dst) {
        if (dst == null || dst.length < src.length) {
            dst = new Point3D[src.length];
        }
        int i = 0;
        while (i < src.length) {
            dst[i] = new Point3D(src[i].getX() * this.m00 + src[i].getY() * this.m01 + src[i].getZ() * this.m02 + this.m03, src[i].getX() * this.m10 + src[i].getY() * this.m11 + src[i].getZ() * this.m12 + this.m13, src[i].getX() * this.m20 + src[i].getY() * this.m21 + src[i].getZ() * this.m22 + this.m23);
            ++i;
        }
        return dst;
    }

    public Point3D transformPoint(Point3D src) {
        return new Point3D(src.getX() * this.m00 + src.getY() * this.m01 + src.getZ() * this.m02 + this.m03, src.getX() * this.m10 + src.getY() * this.m11 + src.getZ() * this.m12 + this.m13, src.getX() * this.m20 + src.getY() * this.m21 + src.getZ() * this.m22 + this.m23);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AffineTransform3D)) {
            return false;
        }
        double[] tab = ((AffineTransform3D)obj).coefficients();
        if (Math.abs(tab[0] - this.m00) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[1] - this.m01) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[2] - this.m02) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[3] - this.m03) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[4] - this.m10) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[5] - this.m11) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[6] - this.m12) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[7] - this.m13) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[8] - this.m20) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[9] - this.m21) > 1.0E-12) {
            return false;
        }
        if (Math.abs(tab[10] - this.m22) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(tab[11] - this.m23) > 1.0E-12);
    }
}

