/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhijia.OAuth1;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

class Base64 {
    static final int CHUNK_SIZE = 76;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] intToBase64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] base64ToInt;
    private final int lineLength;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;
    private byte[] buf;
    private int pos;
    private int readPos;
    private int currentLinePos;
    private int modulus;
    private boolean eof;
    private int x;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        base64ToInt = byArray;
    }

    public Base64() {
        this(76, CHUNK_SEPARATOR);
    }

    public Base64(int lineLength) {
        this(lineLength, CHUNK_SEPARATOR);
    }

    public Base64(int lineLength, byte[] lineSeparator) {
        this.lineLength = lineLength;
        this.lineSeparator = new byte[lineSeparator.length];
        System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
        this.encodeSize = lineLength > 0 ? 4 + lineSeparator.length : 4;
        this.decodeSize = this.encodeSize - 1;
        if (Base64.containsBase64Byte(lineSeparator)) {
            String sep;
            try {
                sep = new String(lineSeparator, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                sep = new String(lineSeparator);
            }
            throw new IllegalArgumentException("lineSeperator must not contain base64 characters: [" + sep + "]");
        }
    }

    boolean hasData() {
        return this.buf != null;
    }

    int avail() {
        return this.buf != null ? this.pos - this.readPos : 0;
    }

    private void resizeBuf() {
        if (this.buf == null) {
            this.buf = new byte[8192];
            this.pos = 0;
            this.readPos = 0;
        } else {
            byte[] b = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, b, 0, this.buf.length);
            this.buf = b;
        }
    }

    int readResults(byte[] b, int bPos, int bAvail) {
        if (this.buf != null) {
            int len = Math.min(this.avail(), bAvail);
            if (this.buf != b) {
                System.arraycopy(this.buf, this.readPos, b, bPos, len);
                this.readPos += len;
                if (this.readPos >= this.pos) {
                    this.buf = null;
                }
            } else {
                this.buf = null;
            }
            return len;
        }
        return this.eof ? -1 : 0;
    }

    void setInitialBuffer(byte[] out, int outPos, int outAvail) {
        if (out != null && out.length == outAvail) {
            this.buf = out;
            this.pos = outPos;
            this.readPos = outPos;
        }
    }

    void encode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
            if (this.buf == null || this.buf.length - this.pos < this.encodeSize) {
                this.resizeBuf();
            }
            switch (this.modulus) {
                case 1: {
                    this.buf[this.pos++] = intToBase64[this.x >> 2 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x << 4 & 0x3F];
                    this.buf[this.pos++] = 61;
                    this.buf[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buf[this.pos++] = intToBase64[this.x >> 10 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 4 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x << 2 & 0x3F];
                    this.buf[this.pos++] = 61;
                }
            }
            if (this.lineLength > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            int i = 0;
            while (i < inAvail) {
                int b;
                if (this.buf == null || this.buf.length - this.pos < this.encodeSize) {
                    this.resizeBuf();
                }
                ++this.modulus;
                this.modulus %= 3;
                if ((b = in[inPos++]) < 0) {
                    b += 256;
                }
                this.x = (this.x << 8) + b;
                if (this.modulus == 0) {
                    this.buf[this.pos++] = intToBase64[this.x >> 18 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 12 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 6 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x & 0x3F];
                    this.currentLinePos += 4;
                    if (this.lineLength > 0 && this.lineLength <= this.currentLinePos) {
                        System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                        this.pos += this.lineSeparator.length;
                        this.currentLinePos = 0;
                    }
                }
                ++i;
            }
        }
    }

    void decode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
        }
        int i = 0;
        while (i < inAvail) {
            byte result;
            byte b;
            if (this.buf == null || this.buf.length - this.pos < this.decodeSize) {
                this.resizeBuf();
            }
            if ((b = in[inPos++]) == 61) {
                this.x <<= 6;
                switch (this.modulus) {
                    case 2: {
                        this.x <<= 6;
                        this.buf[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                        break;
                    }
                    case 3: {
                        this.buf[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                        this.buf[this.pos++] = (byte)(this.x >> 8 & 0xFF);
                    }
                }
                this.eof = true;
                return;
            }
            if (b >= 0 && b < base64ToInt.length && (result = base64ToInt[b]) >= 0) {
                ++this.modulus;
                this.modulus %= 4;
                this.x = (this.x << 6) + result;
                if (this.modulus == 0) {
                    this.buf[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                    this.buf[this.pos++] = (byte)(this.x >> 8 & 0xFF);
                    this.buf[this.pos++] = (byte)(this.x & 0xFF);
                }
            }
            ++i;
        }
    }

    public static boolean isBase64(byte octet) {
        return octet == 61 || octet >= 0 && octet < base64ToInt.length && base64ToInt[octet] != -1;
    }

    public static boolean isArrayByteBase64(byte[] arrayOctet) {
        int i = 0;
        while (i < arrayOctet.length) {
            if (!Base64.isBase64(arrayOctet[i]) && !Base64.isWhiteSpace(arrayOctet[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean containsBase64Byte(byte[] arrayOctet) {
        int i = 0;
        while (i < arrayOctet.length) {
            if (Base64.isBase64(arrayOctet[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static byte[] encodeBase64(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, false);
    }

    public static byte[] encodeBase64Chunked(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, true);
    }

    public byte[] decode(byte[] pArray) {
        return Base64.decodeBase64(pArray);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
        if (binaryData == null || binaryData.length == 0) {
            return binaryData;
        }
        Base64 b64 = isChunked ? new Base64() : new Base64(0);
        long len = binaryData.length * 4 / 3;
        long mod = len % 4L;
        if (mod != 0L) {
            len += 4L - mod;
        }
        if (isChunked) {
            len += (1L + len / 76L) * (long)CHUNK_SEPARATOR.length;
        }
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Input array too big, output array would be bigger than Integer.MAX_VALUE=2147483647");
        }
        byte[] buf = new byte[(int)len];
        b64.setInitialBuffer(buf, 0, buf.length);
        b64.encode(binaryData, 0, binaryData.length);
        b64.encode(binaryData, 0, -1);
        if (b64.buf != buf) {
            b64.readResults(buf, 0, buf.length);
        }
        return buf;
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        if (base64Data == null || base64Data.length == 0) {
            return base64Data;
        }
        Base64 b64 = new Base64();
        long len = base64Data.length * 3 / 4;
        byte[] buf = new byte[(int)len];
        b64.setInitialBuffer(buf, 0, buf.length);
        b64.decode(base64Data, 0, base64Data.length);
        b64.decode(base64Data, 0, -1);
        byte[] result = new byte[b64.pos];
        b64.readResults(result, 0, result.length);
        return result;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    static byte[] discardNonBase64(byte[] data) {
        byte[] groomedData = new byte[data.length];
        int bytesCopied = 0;
        int i = 0;
        while (i < data.length) {
            if (Base64.isBase64(data[i])) {
                groomedData[bytesCopied++] = data[i];
            }
            ++i;
        }
        byte[] packedData = new byte[bytesCopied];
        System.arraycopy(groomedData, 0, packedData, 0, bytesCopied);
        return packedData;
    }

    public byte[] encode(byte[] pArray) {
        return Base64.encodeBase64(pArray, false);
    }

    public static BigInteger decodeInteger(byte[] pArray) {
        return new BigInteger(1, Base64.decodeBase64(pArray));
    }

    public static byte[] encodeInteger(BigInteger bigInt) {
        if (bigInt == null) {
            throw new NullPointerException("encodeInteger called with null parameter");
        }
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInt), false);
    }

    static byte[] toIntegerBytes(BigInteger bigInt) {
        int bitlen = bigInt.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInt.toByteArray();
        if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInt.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }
}

