/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhijia.OAuth1;

import com.yunzhijia.OAuth1.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OAuth
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
    private final String HMAC_SHA1 = "HmacSHA1";
    private final String CHARACTER_ENCODING = "UTF-8";
    private Parameter OAUTH_SIGNATURE_METHOD = null;
    private String consumerKey;
    private String consumerSecret;

    public OAuth(String consumerKey, String consumerSecret) {
        this.setConsumerKey(consumerKey);
        this.setConsumerSecret(consumerSecret);
        this.OAUTH_SIGNATURE_METHOD = new Parameter("oauth_signature_method", "HMAC-SHA1");
    }

    String generateAuthorizationHeader(String method, String url, Parameter[] params, String nonce, String timestamp, String authToken, String authSecret) {
        if (params == null) {
            params = new Parameter[]{};
        }
        ArrayList<Parameter> oauthHeaderParams = new ArrayList<Parameter>(5);
        oauthHeaderParams.add(new Parameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(new Parameter("oauth_token", authToken));
        oauthHeaderParams.add(this.OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new Parameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new Parameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new Parameter("oauth_version", "1.0"));
        ArrayList<Parameter> signatureBaseParams = new ArrayList<Parameter>(oauthHeaderParams.size() + params.length);
        signatureBaseParams.addAll(oauthHeaderParams);
        signatureBaseParams.addAll(this.toParamList(params));
        this.parseGetParameters(url, signatureBaseParams);
        String baseStr = null;
        try {
            baseStr = String.valueOf(this.percentEncode(method.toUpperCase())) + '&' + this.percentEncode(this.normalizeUrl(url)) + '&' + this.percentEncode(this.normalizeParameters(signatureBaseParams));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] expected = null;
        try {
            expected = this.computeSignature(this.consumerSecret, authSecret, baseStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String signature = this.base64Encode(expected);
        oauthHeaderParams.add(new Parameter("oauth_signature", signature));
        return "OAuth " + this.makeParameters(oauthHeaderParams, ",", true);
    }

    public String makeParameters(List<Parameter> params, String splitter, boolean quot) {
        StringBuffer buf = new StringBuffer();
        for (Parameter param : params) {
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(param.getKey()).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(this.percentEncode(param.getValue()));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    protected String normalizeParameters(Collection<? extends Map.Entry> parameters) throws IOException {
        if (parameters == null) {
            return "";
        }
        ArrayList<ComparableParameter> p = new ArrayList<ComparableParameter>(parameters.size());
        for (Map.Entry entry : parameters) {
            if ("oauth_signature".equals(entry.getKey())) continue;
            p.add(new ComparableParameter(entry));
        }
        Collections.sort(p);
        return this.formEncode(this.getParameters(p));
    }

    private List<Map.Entry> getParameters(Collection<ComparableParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(parameters.size());
        for (ComparableParameter parameter : parameters) {
            list.add(parameter.value);
        }
        return list;
    }

    public String formEncode(Iterable<? extends Map.Entry> parameters) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        this.formEncode(parameters, b);
        return this.decodeCharacters(b.toByteArray());
    }

    public String decodeCharacters(byte[] from) {
        try {
            return new String(from, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("" + e);
            return new String(from);
        }
    }

    public void formEncode(Iterable<? extends Map.Entry> parameters, OutputStream into) {
        if (parameters != null) {
            boolean first = true;
            for (Map.Entry entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    try {
                        into.write(38);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    into.write(this.encodeCharacters(this.percentEncode(this.toString(entry.getKey()))));
                    into.write(61);
                    into.write(this.encodeCharacters(this.percentEncode(this.toString(entry.getValue()))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public byte[] encodeCharacters(String from) {
        try {
            return from.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("" + e);
            return from.getBytes();
        }
    }

    private final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    protected String normalizeUrl(String url) {
        String path;
        int index;
        boolean dropPort;
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return String.valueOf(scheme) + "://" + authority + path;
    }

    public String base64Encode(byte[] b) {
        byte[] b2 = new Base64().encode(b);
        try {
            return new String(b2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("" + e);
            return new String(b2);
        }
    }

    public byte[] computeSignature(String consumerSecret, String tokenSecret, String baseString) throws Exception {
        SecretKeySpec key = null;
        String keyString = String.valueOf(this.percentEncode(consumerSecret)) + '&' + this.percentEncode(tokenSecret);
        byte[] keyBytes = keyString.getBytes("UTF-8");
        key = new SecretKeySpec(keyBytes, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(key);
        byte[] text = baseString.getBytes("UTF-8");
        return mac.doFinal(text);
    }

    public String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    private void parseGetParameters(String url, List<Parameter> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                String[] stringArray = queryStrs;
                int n = queryStrs.length;
                int n2 = 0;
                while (n2 < n) {
                    String query = stringArray[n2];
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.add(new Parameter(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8")));
                    } else {
                        signatureBaseParams.add(new Parameter(URLDecoder.decode(split[0], "UTF-8"), ""));
                    }
                    ++n2;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String generateAuthorizationHeader(String method, String url, Parameter[] params, String authToken, String authSecret) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = this.getNonce(6);
        return this.generateAuthorizationHeader(method, url, params, nonce, timestamp, authToken, authSecret);
    }

    public String getNonce(int length) {
        String result = "";
        int i = 0;
        while (i < 6) {
            int rnum = (int)Math.floor(Math.random() * (double)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz".length());
            result = String.valueOf(result) + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz".substring(rnum, rnum + 1);
            ++i;
        }
        return result;
    }

    public List<Parameter> toParamList(Parameter[] params) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>(params.length);
        paramList.addAll(Arrays.asList(params));
        return paramList;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey != null ? consumerKey : "";
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret != null ? consumerSecret : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth)) {
            return false;
        }
        OAuth oAuth = (OAuth)o;
        if (this.consumerKey != null ? !this.consumerKey.equals(oAuth.consumerKey) : oAuth.consumerKey != null) {
            return false;
        }
        return !(this.consumerSecret != null ? !this.consumerSecret.equals(oAuth.consumerSecret) : oAuth.consumerSecret != null);
    }

    public int hashCode() {
        int result = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        result = 31 * result + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuth{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='" + this.consumerSecret + '\'' + '}';
    }

    private class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Map.Entry value;
        private final String key;

        ComparableParameter(Map.Entry value) {
            this.value = value;
            String n = this.toString(value.getKey());
            String v = this.toString(value.getValue());
            this.key = String.valueOf(OAuth.this.percentEncode(n)) + ' ' + OAuth.this.percentEncode(v);
        }

        private String toString(Object from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.key.compareTo(that.key);
        }

        public String toString() {
            return this.key;
        }
    }

    public class Parameter
    implements Map.Entry<String, String> {
        private final String key;
        private String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            try {
                String string = this.value;
                return string;
            }
            finally {
                this.value = value;
            }
        }

        public String toString() {
            return String.valueOf(OAuth.this.percentEncode(this.getKey())) + '=' + OAuth.this.percentEncode(this.getValue());
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter that = (Parameter)obj;
            if (this.key == null ? that.key != null : !this.key.equals(that.key)) {
                return false;
            }
            return !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }
    }
}

