/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.measurements;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.UdpInfluxdbProtocol;
import metrics_influxdb.measurements.Measure;
import metrics_influxdb.measurements.QueueableSender;
import metrics_influxdb.misc.Miscellaneous;
import metrics_influxdb.serialization.line.Inliner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpInlinerSender
extends QueueableSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpInlinerSender.class);
    private static int MAX_MEASURES_IN_SINGLE_POST = 5000;
    private final Inliner inliner = new Inliner(TimeUnit.NANOSECONDS);
    private final InetSocketAddress serverAddress;

    public UdpInlinerSender(UdpInfluxdbProtocol protocol) {
        super(MAX_MEASURES_IN_SINGLE_POST);
        this.serverAddress = new InetSocketAddress(protocol.host, protocol.port);
    }

    @Override
    protected boolean doSend(Collection<Measure> measures) {
        if (measures.isEmpty()) {
            return true;
        }
        DatagramChannel channel = null;
        try {
            channel = DatagramChannel.open();
        }
        catch (IOException e) {
            LOGGER.error("failed open udp channel", (Throwable)e);
            return false;
        }
        Iterator<Measure> measuresIterator = measures.iterator();
        int errorCounter = 0;
        int successCounter = 0;
        while (measuresIterator.hasNext()) {
            String measuresAsString = this.inliner.inline(measuresIterator.next());
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Measure being sent:\n{}", (Object)measuresAsString);
                }
                ByteBuffer buffer = ByteBuffer.wrap(measuresAsString.getBytes(Miscellaneous.UTF8));
                channel.send(buffer, this.serverAddress);
                ++successCounter;
            }
            catch (Throwable e) {
                ++errorCounter;
            }
        }
        LOGGER.debug("{} Measures sent to UDP[{}:{}]; successes: {}, failures: {}", new Object[]{measures.size(), this.serverAddress.getHostString(), this.serverAddress.getPort(), successCounter, errorCounter});
        try {
            channel.close();
        }
        catch (IOException e) {
            LOGGER.error("failed close udp channel", (Throwable)e);
        }
        return successCounter > 0;
    }
}

