/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.v08;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import metrics_influxdb.v08.Influxdb;
import metrics_influxdb.v08.JsonBuilder;
import metrics_influxdb.v08.JsonBuilderDefault;

public class InfluxdbUdp
implements Influxdb {
    protected final ArrayList<JsonBuilder> jsonBuilders = new ArrayList();
    private final String host;
    private final int port;
    public boolean debugJson = false;

    public InfluxdbUdp(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void resetRequest() {
        this.jsonBuilders.clear();
    }

    @Override
    public boolean hasSeriesData() {
        return !this.jsonBuilders.isEmpty();
    }

    @Override
    public long convertTimestamp(long timestamp) {
        return timestamp / 1000L;
    }

    @Override
    public void appendSeries(String namePrefix, String name, String nameSuffix, String[] columns, Object[][] points) {
        JsonBuilderDefault jsonBuilder = new JsonBuilderDefault();
        jsonBuilder.reset();
        jsonBuilder.appendSeries(namePrefix, name, nameSuffix, columns, points);
        this.jsonBuilders.add(jsonBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendRequest(boolean throwExc, boolean printJson) throws Exception {
        try (DatagramChannel channel = null;){
            channel = DatagramChannel.open();
            InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
            for (JsonBuilder builder : this.jsonBuilders) {
                String json = builder.toJsonString();
                if (printJson || this.debugJson) {
                    System.out.println(json);
                }
                ByteBuffer buffer = ByteBuffer.wrap(json.getBytes());
                channel.send(buffer, socketAddress);
                buffer.clear();
            }
        }
        return 0;
    }
}

