/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.connection.examples;

import cn.topca.connection.ConnectionSessionSpi;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;

public class SampleConnectionSession
extends ConnectionSessionSpi {
    private URLConnection connection;
    private boolean closed;
    private static final long ONE_SECOND = 1000L;

    protected SampleConnectionSession(URLConnection connection) throws IOException {
        if (connection == null) {
            throw new IOException("please connect first");
        }
        this.connection = connection;
    }

    protected void engineSetSessionTimeout(int timeout) throws IOException {
        this.connection.setReadTimeout(timeout);
    }

    protected int engineGetSessionTimeout() {
        return this.connection.getReadTimeout();
    }

    protected OutputStream engineGetOutputStream() throws IOException {
        if (this.closed) {
            throw new IOException("Session closed");
        }
        return this.connection.getOutputStream();
    }

    protected InputStream engineGetInputStream() throws IOException {
        if (this.closed) {
            throw new IOException("Session closed");
        }
        return this.connection.getInputStream();
    }

    public void engineClose(boolean immediately) throws IOException {
        if (!immediately) {
            while (this.connection.getInputStream().available() > 0) {
                this.sleep(1000L);
            }
        }
        this.connection.getInputStream().reset();
        this.closed = true;
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean engineIsClosed() throws IOException {
        return this.closed;
    }
}

