/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core;

import cn.topca.core.NoSuchProvider;
import cn.topca.core.NoSuchServiceAlgorithm;
import cn.topca.core.ServiceProvider;
import cn.topca.core.ServiceProviderInterface;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

public abstract class AbstractService {
    private final ServiceEngine engine;

    protected AbstractService(ServiceEngine engine) {
        this.engine = engine;
    }

    protected ServiceProviderInterface getSpi() {
        return this.engine.getSpi();
    }

    public double getVersion() {
        return this.engine.getVersion();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }

    protected Provider getProvider() {
        return this.engine.getProvider();
    }

    private static ServiceProvider.Delegate getProvider(String name) throws NoSuchProvider {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider p = Security.getProvider(name);
        if (p == null || !(p instanceof ServiceProvider.Delegate)) {
            throw new NoSuchProvider("no such provider: " + name);
        }
        return (ServiceProvider.Delegate)p;
    }

    private static ServiceProvider.Delegate getFirstProvider(String service, String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders(service + "." + algorithm);
        if (providers != null && providers.length > 0) {
            for (Provider p : providers) {
                if (!(p instanceof ServiceProvider.Delegate)) continue;
                return (ServiceProvider.Delegate)p;
            }
        }
        throw new NoSuchAlgorithmException(algorithm + " " + service + " not available");
    }

    protected static ServiceEngine getServiceEngine(String service, String algorithm) throws NoSuchServiceAlgorithm {
        try {
            return AbstractService.getServiceEngine(service, algorithm, AbstractService.getFirstProvider(service, algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchServiceAlgorithm(e.getMessage(), e);
        }
    }

    protected static ServiceEngine getServiceEngine(String service, String algorithm, String provider) throws NoSuchServiceAlgorithm, NoSuchProvider {
        try {
            return AbstractService.getServiceEngine(service, algorithm, AbstractService.getProvider(provider));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchServiceAlgorithm(e.getMessage(), e);
        }
    }

    protected static ServiceEngine getServiceEngine(String service, String algorithm, ServiceProvider provider) throws NoSuchServiceAlgorithm {
        try {
            return AbstractService.getServiceEngine(service, algorithm, provider.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchServiceAlgorithm(e.getMessage(), e);
        }
    }

    private static ServiceEngine getServiceEngine(String service, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service s = AbstractService.getProviderService(service, algorithm, provider);
        ServiceProviderInterface spi = (ServiceProviderInterface)s.newInstance(null);
        return new ServiceEngine(spi, provider.getVersion(), s.getAlgorithm(), provider);
    }

    private static Provider.Service getProviderService(String service, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Provider.Service s = provider.getService(service, algorithm);
        if (s == null) {
            throw new NoSuchAlgorithmException("no such " + algorithm + " for " + provider.getName());
        }
        return s;
    }

    protected static class ServiceEngine {
        private final ServiceProviderInterface spi;
        private final double version;
        private final String algorithm;
        private final Provider provider;

        public ServiceEngine(ServiceProviderInterface spi, double version, String algorithm, Provider provider) {
            this.spi = spi;
            this.version = version;
            this.algorithm = algorithm;
            this.provider = provider;
        }

        public ServiceProviderInterface getSpi() {
            return this.spi;
        }

        public double getVersion() {
            return this.version;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public Provider getProvider() {
            return this.provider;
        }
    }
}

