/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.asn1.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.BERSequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.tca.TopBasicCrypto.asn1.cms.OriginatorInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientInfo;
import cn.topca.core.ext.bc.asn1.cms.EncryptedContentInfo;
import java.util.Enumeration;

public class EnvelopedData
extends ASN1Encodable {
    private DERInteger version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private ASN1Set unprotectedAttrs;

    public EnvelopedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, EncryptedContentInfo encryptedContentInfo, ASN1Set unprotectedAttrs) {
        if (originatorInfo != null || unprotectedAttrs != null) {
            this.version = new DERInteger(2);
        } else {
            this.version = new DERInteger(0);
            Enumeration e = recipientInfos.getObjects();
            while (e.hasMoreElements()) {
                RecipientInfo ri = RecipientInfo.getInstance(e.nextElement());
                if (ri.getVersion().equals((Object)this.version)) continue;
                this.version = new DERInteger(2);
                break;
            }
        }
        this.originatorInfo = originatorInfo;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = unprotectedAttrs;
    }

    public EnvelopedData(ASN1Sequence seq) {
        int index = 0;
        this.version = (DERInteger)seq.getObjectAt(index++);
        DEREncodable tmp = seq.getObjectAt(index++);
        if (tmp instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)((ASN1TaggedObject)tmp), (boolean)false);
            tmp = seq.getObjectAt(index++);
        }
        this.recipientInfos = ASN1Set.getInstance((Object)tmp);
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(seq.getObjectAt(index++));
        if (seq.size() > index) {
            this.unprotectedAttrs = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(index)), (boolean)false);
        }
    }

    public static EnvelopedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return EnvelopedData.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static EnvelopedData getInstance(Object obj) {
        if (obj == null || obj instanceof EnvelopedData) {
            return (EnvelopedData)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new EnvelopedData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid EnvelopedData: " + obj.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.version);
        if (this.originatorInfo != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.originatorInfo));
        }
        v.add((DEREncodable)this.recipientInfos);
        v.add((DEREncodable)this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.unprotectedAttrs));
        }
        return new BERSequence(v);
    }
}

