/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.cms.AttributeTable;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.EncryptedContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.EnvelopedData;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.topca.core.ext.bc.cms.CMSEnvelopedHelper;
import cn.topca.core.ext.bc.cms.CMSProcessableByteArray;
import cn.topca.core.ext.bc.cms.CMSUtils;
import cn.topca.core.ext.bc.cms.RecipientInformationStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class CMSEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier encAlg;
    private ASN1Set unprotectedAttributes;

    public CMSEnvelopedData(byte[] envelopedData) throws CMSException {
        this(CMSUtils.readContentInfo(envelopedData));
    }

    public CMSEnvelopedData(InputStream envelopedData) throws CMSException {
        this(CMSUtils.readContentInfo(envelopedData));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        EnvelopedData envData = EnvelopedData.getInstance((Object)contentInfo.getContent());
        ASN1Set recipientInfos = envData.getRecipientInfos();
        EncryptedContentInfo encInfo = envData.getEncryptedContentInfo();
        this.encAlg = encInfo.getContentEncryptionAlgorithm();
        CMSProcessableByteArray readable = new CMSProcessableByteArray(encInfo.getEncryptedContent().getOctets());
        CMSEnvelopedHelper.CMSEnvelopedSecureReadable secureReadable = new CMSEnvelopedHelper.CMSEnvelopedSecureReadable(this.encAlg, readable);
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.encAlg, secureReadable);
        this.unprotectedAttributes = envData.getUnprotectedAttrs();
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            return obj.getDERObject().getEncoded();
        }
        return null;
    }

    public String getEncryptionAlgOID() {
        return this.encAlg.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return this.getEncryptionAlgorithmParameters(CMSUtils.getProvider(provider));
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(Provider provider) throws CMSException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public AttributeTable getUnprotectedAttributes() {
        if (this.unprotectedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unprotectedAttributes);
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

