/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.SignerIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.TBSCertificateStructure;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.cert.CertException;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.RecipientInfoGenerator;
import cn.tca.TopBasicCrypto.cms.SignerId;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.ContentVerifierProvider;
import cn.tca.TopBasicCrypto.operator.DigestCalculatorProvider;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.operator.OutputEncryptor;
import cn.tca.TopBasicCrypto.util.CollectionStore;
import cn.tca.TopBasicCrypto.util.Selector;
import cn.tca.TopBasicCrypto.util.Store;
import cn.tca.TopBasicCrypto.x509.X509CertStoreSelector;
import cn.topca.core.ext.bc.asn1.cms.CMSObjectIdentifiers;
import cn.topca.core.ext.bc.cms.CMSEnvelopedData;
import cn.topca.core.ext.bc.cms.CMSEnvelopedDataGenerator;
import cn.topca.core.ext.bc.cms.CMSProcessableByteArray;
import cn.topca.core.ext.bc.cms.CMSSignedData;
import cn.topca.core.ext.bc.cms.CMSSignedDataGenerator;
import cn.topca.core.ext.bc.cms.RecipientInformation;
import cn.topca.core.ext.bc.cms.RecipientInformationStore;
import cn.topca.core.ext.bc.cms.SignerInfoGenerator;
import cn.topca.core.ext.bc.cms.SignerInformation;
import cn.topca.core.ext.bc.cms.SignerInformationStore;
import cn.topca.core.ext.bc.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cn.topca.core.ext.bc.cms.jcajce.JceCMSContentEncryptorBuilder;
import cn.topca.core.ext.bc.cms.jcajce.JceKeyTransEnvelopedRecipient;
import cn.topca.core.ext.bc.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cn.topca.core.ext.bc.operator.jcajce.JcaContentSignerBuilder;
import cn.topca.core.ext.bc.operator.jcajce.JcaContentVerifierProviderBuilder;
import cn.topca.core.ext.bc.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cn.topca.core.ext.bc.util.X509CertificateHolderSelector;
import cn.topca.security.JCAJCEUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSOperatorUtils {
    private static final Logger log = LoggerFactory.getLogger(Certificate.class);
    private static Provider smProvider = null;

    public static CMSEnvelopedData generateEnvelopedData(byte[] origin, Certificate recipientCert, ASN1ObjectIdentifier encryptionAlgorithm) throws CertificateEncodingException, CMSException {
        boolean useGMStyle = JCAJCEUtils.isGMAlgorithm(recipientCert.getPublicKey().getAlgorithm());
        return CMSOperatorUtils.generateEnvelopedData(origin, recipientCert, encryptionAlgorithm, useGMStyle);
    }

    public static CMSEnvelopedData generateEnvelopedData(byte[] origin, Certificate recipientCert, ASN1ObjectIdentifier encryptionAlgorithm, boolean useGMStyle) throws CertificateEncodingException, CMSException {
        CMSEnvelopedDataGenerator envelopedDataGenerator = new CMSEnvelopedDataGenerator();
        envelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator((X509Certificate)recipientCert));
        CMSProcessableByteArray typedData = new CMSProcessableByteArray(origin);
        OutputEncryptor outputEncryptor = new JceCMSContentEncryptorBuilder(encryptionAlgorithm).build();
        CMSEnvelopedData envelopedData = envelopedDataGenerator.generate(typedData, outputEncryptor);
        if (useGMStyle) {
            ContentInfo contentinfo = new ContentInfo(CMSObjectIdentifiers.gm_envelopedData, envelopedData.getContentInfo().getContent());
            envelopedData = new CMSEnvelopedData(contentinfo);
        }
        return envelopedData;
    }

    public static CMSEnvelopedData generateEnvelopedDatas(byte[] origin, Certificate[] recipientCerts, ASN1ObjectIdentifier encryptionAlgorithm, boolean useGMStyle) throws CertificateEncodingException, CMSException {
        CMSEnvelopedDataGenerator envelopedDataGenerator = new CMSEnvelopedDataGenerator();
        for (Certificate recipientCert : recipientCerts) {
            envelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator((X509Certificate)recipientCert));
        }
        CMSProcessableByteArray typedData = new CMSProcessableByteArray(origin);
        OutputEncryptor outputEncryptor = new JceCMSContentEncryptorBuilder(encryptionAlgorithm).build();
        CMSEnvelopedData envelopedData = envelopedDataGenerator.generate(typedData, outputEncryptor);
        ArrayList contentinfos = new ArrayList();
        if (useGMStyle) {
            ContentInfo contentinfo = new ContentInfo(CMSObjectIdentifiers.gm_envelopedData, envelopedData.getContentInfo().getContent());
            envelopedData = new CMSEnvelopedData(contentinfo);
        }
        return envelopedData;
    }

    public static CMSSignedData generateSignedData(byte[] plaintext, PrivateKey privateKey, Certificate signCert, Provider provider, boolean encapsulate) throws OperatorCreationException, CMSException, CertificateEncodingException {
        X509CertificateStructure x509 = X509CertificateStructure.getInstance((Object)signCert.getEncoded());
        TBSCertificateStructure x509tbs = x509.getTBSCertificate();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)x509tbs.getIssuer());
        v.add((DEREncodable)x509tbs.getSerialNumber());
        IssuerAndSerialNumber id = new IssuerAndSerialNumber((ASN1Sequence)new DERSequence(v));
        SignerIdentifier signerIdentifier = new SignerIdentifier(id);
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(x509tbs.getSignature().getAlgorithm().getId());
        if (provider != null) {
            contentSignerBuilder.setProvider(provider);
        }
        ContentSigner contentSigner = contentSignerBuilder.build(privateKey);
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().build();
        SignerInfoGenerator infoGen = new SignerInfoGenerator(signerIdentifier, contentSigner, digestCalculatorProvider, false);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        gen.addSignerInfoGenerator(infoGen);
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>();
        X509CertificateHolder certHolder = new X509CertificateHolder(x509);
        certs.add(certHolder);
        CollectionStore certStore = new CollectionStore(certs);
        gen.addCertificates((Store)certStore);
        CMSProcessableByteArray msgContent = new CMSProcessableByteArray(plaintext);
        return gen.generate(msgContent, encapsulate);
    }

    public static CMSSignedData generateSignedData(byte[] plaintext, PrivateKey privateKey, Certificate signCert, Provider provider) throws OperatorCreationException, CMSException, CertificateEncodingException {
        return CMSOperatorUtils.generateSignedData(plaintext, privateKey, signCert, provider, true);
    }

    public static SignedDataVerifyResult verifySignedData(InputStream signedData, Store trustCerts) throws CMSException, IOException, CertificateException, OperatorCreationException, CertException {
        CMSSignedData cmsSignedData = new CMSSignedData(signedData);
        return CMSOperatorUtils.verifySignedData(cmsSignedData, trustCerts);
    }

    public static SignedDataVerifyResult verifySignedData(CMSSignedData cmsSignedData, Store trustCerts) throws CMSException, IOException, CertificateException, OperatorCreationException, CertException {
        byte[] plaintext = null;
        if (cmsSignedData.getSignedContent() != null) {
            plaintext = (byte[])cmsSignedData.getSignedContent().getContent();
        }
        return CMSOperatorUtils.verifySignedData(cmsSignedData, trustCerts, plaintext);
    }

    public static SignedDataVerifyResult verifySignedData(InputStream signedData, Store trustCerts, byte[] plaintext) throws CMSException, IOException, CertificateException, OperatorCreationException, CertException {
        CMSSignedData cmsSignedData = new CMSSignedData(signedData);
        return CMSOperatorUtils.verifySignedData(cmsSignedData, trustCerts, plaintext);
    }

    public static SignedDataVerifyResult verifySignedData(CMSSignedData cmsSigned, Store trustCerts, byte[] plaintext) throws CMSException, IOException, CertificateException, OperatorCreationException, CertException {
        SignerInformationStore signerInfos = cmsSigned.getSignerInfos();
        Store certs = cmsSigned.getCertificates();
        Collection signers = signerInfos.getSigners();
        Iterator it = signers.iterator();
        SignedDataVerifyResult result = new SignedDataVerifyResult();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            if (plaintext != null) {
                System.out.println();
            }
            if (trustCerts != null) {
                X509CertStoreSelector caSelector = new X509CertStoreSelector();
                caSelector.setSubject(cert.getIssuer().getEncoded());
                Collection caCollection = trustCerts.getMatches((Selector)caSelector);
                if (caCollection.size() < 1) {
                    result.setFailed(signer.getSID(), VerifyStatus.UnTrusted);
                    continue;
                }
                Iterator caIt = caCollection.iterator();
                X509CertificateHolder caCert = (X509CertificateHolder)caIt.next();
                ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().build(caCert);
                if (!cert.isSignatureValid(verifierProvider)) {
                    result.setFailed(signer.getSID(), VerifyStatus.UnTrusted);
                    continue;
                }
            }
            if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert))) {
                result.setFailed(signer.getSID(), VerifyStatus.Failed);
                continue;
            }
            result.setSuccess(signer.getSID());
        }
        result.setPlaintext(plaintext);
        return result;
    }

    public static SignedDataVerifyResult verifySignedDatas(CMSSignedData cmsSigned, Store trustCerts, byte[] plaintext) throws CMSException, IOException, CertificateException, OperatorCreationException, CertException {
        SignerInformationStore signerInfos = cmsSigned.getSignerInfos();
        Store certs = cmsSigned.getCertificates();
        Collection signers = signerInfos.getSigners();
        Iterator it = signers.iterator();
        SignedDataVerifyResult result = new SignedDataVerifyResult();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            X509Certificate x509Certificate = CMSOperatorUtils.getX509Cert(cert);
            signer.getSID().setCertificate(x509Certificate);
            if (plaintext != null) {
                System.out.println();
            }
            if (trustCerts != null) {
                ContentVerifierProvider verifierProvider;
                X509CertificateHolderSelector caSelector = new X509CertificateHolderSelector();
                caSelector.setSubject(cert.getIssuer().getEncoded());
                Collection caCollection = trustCerts.getMatches((Selector)caSelector);
                if (caCollection.size() < 1) {
                    result.setFailed(signer.getSID(), VerifyStatus.UnTrusted);
                    log.debug("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u7b26\u5408\u53ef\u4fe1CA");
                    continue;
                }
                Iterator caIt = caCollection.iterator();
                X509CertificateHolder caCert = (X509CertificateHolder)caIt.next();
                JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();
                if (x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
                    smProvider = null;
                }
                if (smProvider != null) {
                    builder.setProvider(smProvider);
                }
                if (!cert.isSignatureValid(verifierProvider = builder.build(caCert))) {
                    result.setFailed(signer.getSID(), VerifyStatus.UnTrusted);
                    continue;
                }
            }
            result.setSuccess(signer.getSID());
        }
        result.setPlaintext(plaintext);
        return result;
    }

    public static SignedDataVerifyResult verifySignedDatas(CMSSignedData cmsSigned, byte[] plaintext, X509Certificate x509Certificate) throws CMSException, IOException, CertificateException, OperatorCreationException, CertException {
        SignerInformationStore signerInfos = cmsSigned.getSignerInfos();
        Collection signers = signerInfos.getSigners();
        Iterator it = signers.iterator();
        SignedDataVerifyResult result = new SignedDataVerifyResult();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            signer.getSID().setCertificate(x509Certificate);
            if (plaintext != null) {
                System.out.println();
            }
            JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
            if (x509Certificate.getPublicKey().getAlgorithm().equals("SM2") && smProvider != null) {
                builder.setProvider(smProvider);
            }
            if (!signer.verify(builder.build(x509Certificate))) {
                result.setFailed(signer.getSID(), VerifyStatus.Failed);
                continue;
            }
            result.setSuccess(signer.getSID());
        }
        result.setPlaintext(plaintext);
        return result;
    }

    public static X509Certificate getX509Cert(X509CertificateHolder x509CertificateHolder) throws IOException, CertificateException {
        CertificateFactory cf = smProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", smProvider);
        ByteArrayInputStream is1 = new ByteArrayInputStream(x509CertificateHolder.toASN1Structure().getEncoded());
        X509Certificate theCert = (X509Certificate)cf.generateCertificate(is1);
        ((InputStream)is1).close();
        return theCert;
    }

    public static byte[] decryptEnvelopedData(InputStream envelopedData, PrivateKey privateKey, Provider provider) throws CMSException, IOException {
        CMSEnvelopedData cmsEnvelopedData = new CMSEnvelopedData(envelopedData);
        RecipientInformationStore recipients = cmsEnvelopedData.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            JceKeyTransEnvelopedRecipient keyTransEnvelopedRecipient = new JceKeyTransEnvelopedRecipient(privateKey);
            if (provider != null) {
                keyTransEnvelopedRecipient.setProvider(provider);
            }
            return recipient.getContent((Recipient)keyTransEnvelopedRecipient);
        }
        return null;
    }

    private static String toStringSerialNumber(BigInteger serialnumber) {
        String sn = serialnumber.toString(16).toUpperCase();
        if (sn.length() % 2 == 1) {
            sn = "0" + sn;
        }
        return sn;
    }

    static {
        smProvider = Security.getProvider("TopSM");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerifyStatus {
        Success,
        Failed,
        UnTrusted;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignedDataVerifyResult {
        private byte[] plaintext;
        private Set<SignerId> success = new HashSet<SignerId>();
        private Map<SignerId, VerifyStatus> failed = new HashMap<SignerId, VerifyStatus>();

        SignedDataVerifyResult() {
        }

        void setPlaintext(byte[] plaintext) {
            this.plaintext = plaintext;
        }

        void setSuccess(SignerId sid) {
            this.success.add(sid);
        }

        void setFailed(SignerId sid, VerifyStatus unTrusted) {
            this.failed.put(sid, unTrusted);
        }

        public byte[] getPlaintext() {
            return this.plaintext;
        }

        public Set<SignerId> getSuccess() {
            return this.success;
        }

        public Map<SignerId, VerifyStatus> getFailed() {
            return this.failed;
        }
    }
}

