/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessable;
import cn.tca.TopBasicCrypto.util.io.Streams;
import cn.topca.core.ext.bc.cms.CMSReadable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CMSProcessableInputStream
implements CMSProcessable,
CMSReadable {
    private InputStream input;
    private boolean used = false;

    public CMSProcessableInputStream(InputStream input) {
        this.input = input;
    }

    public InputStream getInputStream() {
        this.checkSingleUsage();
        return this.input;
    }

    public void write(OutputStream zOut) throws IOException, CMSException {
        this.checkSingleUsage();
        Streams.pipeAll((InputStream)this.input, (OutputStream)zOut);
        this.input.close();
    }

    public Object getContent() {
        return this.getInputStream();
    }

    private synchronized void checkSingleUsage() {
        if (this.used) {
            throw new IllegalStateException("CMSProcessableInputStream can only be used once");
        }
        this.used = true;
    }
}

