/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.eac.EACObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.oiw.OIWObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509ObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x9.X9ObjectIdentifiers;
import cn.tca.TopBasicCrypto.cert.X509AttributeCertificateHolder;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSSignedDataGenerator;
import cn.tca.TopBasicCrypto.x509.NoSuchStoreException;
import cn.tca.TopBasicCrypto.x509.X509CollectionStoreParameters;
import cn.tca.TopBasicCrypto.x509.X509Store;
import cn.tca.TopBasicCrypto.x509.X509StoreParameters;
import cn.topca.core.ext.bc.asn1.gm.GMObjectIdentifiers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CMSSignedHelper {
    static final CMSSignedHelper INSTANCE = new CMSSignedHelper();
    private static final Map encryptionAlgs = new HashMap();
    private static final Map digestAlgs = new HashMap();
    private static final Map digestAliases = new HashMap();

    CMSSignedHelper() {
    }

    private static void addEntries(DERObjectIdentifier alias, String digest, String encryption) {
        digestAlgs.put(alias.getId(), digest);
        encryptionAlgs.put(alias.getId(), encryption);
    }

    String getDigestAlgName(String digestAlgOID) {
        String algName = (String)digestAlgs.get(digestAlgOID);
        if (algName != null) {
            return algName;
        }
        return digestAlgOID;
    }

    String[] getDigestAliases(String algName) {
        String[] aliases = (String[])digestAliases.get(algName);
        if (aliases != null) {
            return aliases;
        }
        return new String[0];
    }

    String getEncryptionAlgName(String encryptionAlgOID) {
        String algName = (String)encryptionAlgs.get(encryptionAlgOID);
        if (algName != null) {
            return algName;
        }
        return encryptionAlgOID;
    }

    MessageDigest getDigestInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createDigestInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String[] aliases = this.getDigestAliases(algorithm);
            for (int i = 0; i != aliases.length; ++i) {
                try {
                    return this.createDigestInstance(aliases[i], provider);
                }
                catch (NoSuchAlgorithmException ex) {
                    continue;
                }
            }
            if (provider != null) {
                return this.getDigestInstance(algorithm, null);
            }
            throw e;
        }
    }

    private MessageDigest createDigestInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return MessageDigest.getInstance(algorithm, provider);
        }
        return MessageDigest.getInstance(algorithm);
    }

    Signature getSignatureInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return Signature.getInstance(algorithm, provider);
        }
        return Signature.getInstance(algorithm);
    }

    X509Store createAttributeStore(String type, Provider provider, ASN1Set certSet) throws NoSuchStoreException, CMSException {
        ArrayList<X509AttributeCertificateHolder> certs = new ArrayList<X509AttributeCertificateHolder>();
        if (certSet != null) {
            Enumeration e = certSet.getObjects();
            while (e.hasMoreElements()) {
                try {
                    ASN1TaggedObject tagged;
                    DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                    if (!(obj instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)obj).getTagNo() != 2) continue;
                    certs.add(new X509AttributeCertificateHolder(ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)false).getEncoded()));
                }
                catch (IOException ex) {
                    throw new CMSException("can't re-encode attribute certificate!", (Exception)ex);
                }
            }
        }
        try {
            return X509Store.getInstance((String)("AttributeCertificate/" + type), (X509StoreParameters)new X509CollectionStoreParameters(certs), (Provider)provider);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("can't setup the X509Store", (Exception)e);
        }
    }

    X509Store createCertificateStore(String type, Provider provider, ASN1Set certSet) throws NoSuchStoreException, CMSException {
        ArrayList certs = new ArrayList();
        if (certSet != null) {
            this.addCertsFromSet(certs, certSet, provider);
        }
        try {
            return X509Store.getInstance((String)("Certificate/" + type), (X509StoreParameters)new X509CollectionStoreParameters(certs), (Provider)provider);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("can't setup the X509Store", (Exception)e);
        }
    }

    X509Store createCRLsStore(String type, Provider provider, ASN1Set crlSet) throws NoSuchStoreException, CMSException {
        ArrayList crls = new ArrayList();
        if (crlSet != null) {
            this.addCRLsFromSet(crls, crlSet, provider);
        }
        try {
            return X509Store.getInstance((String)("CRL/" + type), (X509StoreParameters)new X509CollectionStoreParameters(crls), (Provider)provider);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("can't setup the X509Store", (Exception)e);
        }
    }

    CertStore createCertStore(String type, Provider provider, ASN1Set certSet, ASN1Set crlSet) throws CMSException, NoSuchAlgorithmException {
        ArrayList certsAndcrls = new ArrayList();
        if (certSet != null) {
            this.addCertsFromSet(certsAndcrls, certSet, provider);
        }
        if (crlSet != null) {
            this.addCRLsFromSet(certsAndcrls, crlSet, provider);
        }
        try {
            if (provider != null) {
                return CertStore.getInstance(type, (CertStoreParameters)new CollectionCertStoreParameters(certsAndcrls), provider);
            }
            return CertStore.getInstance(type, new CollectionCertStoreParameters(certsAndcrls));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("can't setup the CertStore", (Exception)e);
        }
    }

    private void addCertsFromSet(List certs, ASN1Set certSet, Provider provider) throws CMSException {
        CertificateFactory cf;
        try {
            cf = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new CMSException("can't get certificate factory.", (Exception)ex);
        }
        Enumeration e = certSet.getObjects();
        while (e.hasMoreElements()) {
            try {
                DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                if (!(obj instanceof ASN1Sequence)) continue;
                certs.add(cf.generateCertificate(new ByteArrayInputStream(obj.getEncoded())));
            }
            catch (IOException ex) {
                throw new CMSException("can't re-encode certificate!", (Exception)ex);
            }
            catch (CertificateException ex) {
                throw new CMSException("can't re-encode certificate!", (Exception)ex);
            }
        }
    }

    private void addCRLsFromSet(List crls, ASN1Set certSet, Provider provider) throws CMSException {
        CertificateFactory cf;
        try {
            cf = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new CMSException("can't get certificate factory.", (Exception)ex);
        }
        Enumeration e = certSet.getObjects();
        while (e.hasMoreElements()) {
            try {
                DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                crls.add(cf.generateCRL(new ByteArrayInputStream(obj.getEncoded())));
            }
            catch (IOException ex) {
                throw new CMSException("can't re-encode CRL!", (Exception)ex);
            }
            catch (CRLException ex) {
                throw new CMSException("can't re-encode CRL!", (Exception)ex);
            }
        }
    }

    AlgorithmIdentifier fixAlgID(AlgorithmIdentifier algId) {
        if (algId.getParameters() == null) {
            return new AlgorithmIdentifier((DERObjectIdentifier)algId.getAlgorithm(), (DEREncodable)DERNull.INSTANCE);
        }
        return algId;
    }

    void setSigningEncryptionAlgorithmMapping(DERObjectIdentifier oid, String algorithmName) {
        encryptionAlgs.put(oid.getId(), algorithmName);
    }

    void setSigningDigestAlgorithmMapping(DERObjectIdentifier oid, String algorithmName) {
        digestAlgs.put(oid.getId(), algorithmName);
    }

    static {
        CMSSignedHelper.addEntries((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha224, "SHA224", "DSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha256, "SHA256", "DSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha384, "SHA384", "DSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha512, "SHA512", "DSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)OIWObjectIdentifiers.dsaWithSHA1, "SHA1", "DSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)OIWObjectIdentifiers.md4WithRSA, "MD4", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)OIWObjectIdentifiers.md4WithRSAEncryption, "MD4", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)OIWObjectIdentifiers.md5WithRSA, "MD5", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)OIWObjectIdentifiers.sha1WithRSA, "SHA1", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.md4WithRSAEncryption, "MD4", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1", "ECDSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224", "ECDSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256", "ECDSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384", "ECDSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512", "ECDSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1", "DSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_1, "SHA1", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_224, "SHA224", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_256, "SHA256", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_384, "SHA384", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_ECDSA_SHA_512, "SHA512", "ECDSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, "SHA1", "RSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, "SHA256", "RSA");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1, "SHA1", "RSAandMGF1");
        CMSSignedHelper.addEntries(EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, "SHA256", "RSAandMGF1");
        CMSSignedHelper.addEntries((DERObjectIdentifier)GMObjectIdentifiers.sm3withSM2, "SM3", "SM2");
        CMSSignedHelper.addEntries((DERObjectIdentifier)GMObjectIdentifiers.sha1withSM2, "SHA1", "SM2");
        CMSSignedHelper.addEntries((DERObjectIdentifier)GMObjectIdentifiers.sha256withSM2, "SHA256", "SM2");
        CMSSignedHelper.addEntries((DERObjectIdentifier)GMObjectIdentifiers.sm3withRSA, "SM3", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)GMObjectIdentifiers.sha1withRSA, "SHA1", "RSA");
        CMSSignedHelper.addEntries((DERObjectIdentifier)GMObjectIdentifiers.sha256withRSA, "SHA256", "RSA");
        encryptionAlgs.put(X9ObjectIdentifiers.id_dsa.getId(), "DSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.rsaEncryption.getId(), "RSA");
        encryptionAlgs.put(TeleTrusTObjectIdentifiers.teleTrusTRSAsignatureAlgorithm, "RSA");
        encryptionAlgs.put(X509ObjectIdentifiers.id_ea_rsa.getId(), "RSA");
        encryptionAlgs.put(CMSSignedDataGenerator.ENCRYPTION_RSA_PSS, "RSAandMGF1");
        encryptionAlgs.put(CryptoProObjectIdentifiers.gostR3410_94.getId(), "GOST3410");
        encryptionAlgs.put(CryptoProObjectIdentifiers.gostR3410_2001.getId(), "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.6.2", "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.1.5", "GOST3410");
        encryptionAlgs.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001.getId(), "ECGOST3410");
        encryptionAlgs.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94.getId(), "GOST3410");
        encryptionAlgs.put(GMObjectIdentifiers.sm2.getId(), "SM2");
        encryptionAlgs.put(GMObjectIdentifiers.sm9.getId(), "SM9");
        digestAlgs.put(PKCSObjectIdentifiers.md2.getId(), "MD2");
        digestAlgs.put(PKCSObjectIdentifiers.md4.getId(), "MD4");
        digestAlgs.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestAlgs.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestAlgs.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        digestAlgs.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        digestAlgs.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        digestAlgs.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        digestAlgs.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), "RIPEMD128");
        digestAlgs.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), "RIPEMD160");
        digestAlgs.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), "RIPEMD256");
        digestAlgs.put(CryptoProObjectIdentifiers.gostR3411.getId(), "GOST3411");
        digestAlgs.put("1.3.6.1.4.1.5849.1.2.1", "GOST3411");
        digestAlgs.put(GMObjectIdentifiers.sm3.getId(), "SM3");
        digestAliases.put("SHA1", new String[]{"SHA-1"});
        digestAliases.put("SHA224", new String[]{"SHA-224"});
        digestAliases.put("SHA256", new String[]{"SHA-256"});
        digestAliases.put("SHA384", new String[]{"SHA-384"});
        digestAliases.put("SHA512", new String[]{"SHA-512"});
    }
}

