/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Object;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.KeyAgreeRecipientIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.KeyAgreeRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.OriginatorIdentifierOrKey;
import cn.tca.TopBasicCrypto.asn1.cms.OriginatorPublicKey;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientEncryptedKey;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientKeyIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.ecc.MQVuserKeyingMaterial;
import cn.tca.TopBasicCrypto.asn1.pkcs.PrivateKeyInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectKeyIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedGenerator;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.KeyAgreeRecipient;
import cn.tca.TopBasicCrypto.cms.KeyAgreeRecipientId;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.RecipientId;
import cn.tca.TopBasicCrypto.cms.RecipientOperator;
import cn.tca.TopBasicCrypto.jce.spec.MQVPrivateKeySpec;
import cn.tca.TopBasicCrypto.jce.spec.MQVPublicKeySpec;
import cn.topca.core.ext.bc.cms.AuthAttributesProvider;
import cn.topca.core.ext.bc.cms.CMSEnvelopedHelper;
import cn.topca.core.ext.bc.cms.CMSSecureReadable;
import cn.topca.core.ext.bc.cms.OriginatorId;
import cn.topca.core.ext.bc.cms.RecipientInformation;
import cn.topca.crypto.Cipher;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List infos, KeyAgreeRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ASN1Sequence s = info.getRecipientEncryptedKeys();
        for (int i = 0; i < s.size(); ++i) {
            KeyAgreeRecipientId rid;
            RecipientEncryptedKey id = RecipientEncryptedKey.getInstance((Object)s.getObjectAt(i));
            KeyAgreeRecipientIdentifier karid = id.getIdentifier();
            IssuerAndSerialNumber iAndSN = karid.getIssuerAndSerialNumber();
            if (iAndSN != null) {
                rid = new KeyAgreeRecipientId(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier rKeyID = karid.getRKeyID();
                rid = new KeyAgreeRecipientId(rKeyID.getSubjectKeyIdentifier().getOctets());
            }
            infos.add(new KeyAgreeRecipientInformation(info, (RecipientId)rid, id.getEncryptedKey(), messageAlgorithm, secureReadable, additionalData));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo info, RecipientId rid, ASN1OctetString encryptedKey, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = rid;
        this.encryptedKey = encryptedKey;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier recKeyAlgId, OriginatorIdentifierOrKey originator) throws CMSException, IOException {
        OriginatorPublicKey opk = originator.getOriginatorKey();
        if (opk != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(recKeyAlgId, opk);
        }
        OriginatorId origID = new OriginatorId();
        IssuerAndSerialNumber iAndSN = originator.getIssuerAndSerialNumber();
        if (iAndSN != null) {
            origID.setIssuer(iAndSN.getName().getEncoded());
            origID.setSerialNumber(iAndSN.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier ski = originator.getSubjectKeyIdentifier();
            origID.setSubjectKeyIdentifier(ski.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(origID);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier recKeyAlgId, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(recKeyAlgId, originatorPublicKey.getPublicKey().getBytes());
        return pubInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(OriginatorId origID) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    private PublicKey getSenderPublicKey(Key receiverPrivateKey, OriginatorIdentifierOrKey originator, Provider prov) throws CMSException, GeneralSecurityException, IOException {
        SubjectPublicKeyInfo pubInfo = this.getSenderPublicKeyInfo(PrivateKeyInfo.getInstance((Object)receiverPrivateKey.getEncoded()).getAlgorithmId(), originator);
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
        KeyFactory fact = KeyFactory.getInstance(this.keyEncAlg.getAlgorithm().getId(), prov);
        return fact.generatePublic(pubSpec);
    }

    private PublicKey getPublicKeyFromOriginatorPublicKey(Key receiverPrivateKey, OriginatorPublicKey originatorPublicKey, Provider prov) throws CMSException, GeneralSecurityException, IOException {
        SubjectPublicKeyInfo pubInfo = this.getPublicKeyInfoFromOriginatorPublicKey(PrivateKeyInfo.getInstance((Object)receiverPrivateKey.getEncoded()).getAlgorithmId(), originatorPublicKey);
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
        KeyFactory fact = KeyFactory.getInstance(this.keyEncAlg.getAlgorithm().getId(), prov);
        return fact.generatePublic(pubSpec);
    }

    private SecretKey calculateAgreedWrapKey(String wrapAlg, PublicKey senderPublicKey, PrivateKey receiverPrivateKey, Provider prov) throws CMSException, GeneralSecurityException, IOException {
        String agreeAlg = this.keyEncAlg.getAlgorithm().getId();
        if (agreeAlg.equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            byte[] ukmEncoding = this.info.getUserKeyingMaterial().getOctets();
            MQVuserKeyingMaterial ukm = MQVuserKeyingMaterial.getInstance((Object)ASN1Object.fromByteArray((byte[])ukmEncoding));
            PublicKey ephemeralKey = this.getPublicKeyFromOriginatorPublicKey(receiverPrivateKey, ukm.getEphemeralPublicKey(), prov);
            senderPublicKey = new MQVPublicKeySpec(senderPublicKey, ephemeralKey);
            receiverPrivateKey = new MQVPrivateKeySpec(receiverPrivateKey, receiverPrivateKey);
        }
        KeyAgreement agreement = KeyAgreement.getInstance(agreeAlg, prov);
        agreement.init(receiverPrivateKey);
        agreement.doPhase(senderPublicKey, true);
        return agreement.generateSecret(wrapAlg);
    }

    private Key unwrapSessionKey(String wrapAlg, SecretKey agreedKey, Provider prov) throws GeneralSecurityException {
        Cipher keyCipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(wrapAlg, prov);
        keyCipher.init(4, agreedKey);
        return keyCipher.unwrap(this.encryptedKey.getOctets(), this.getContentAlgorithmName(), 3);
    }

    protected Key getSessionKey(Key receiverPrivateKey, Provider prov) throws CMSException {
        try {
            String wrapAlg = AlgorithmIdentifier.getInstance((Object)this.keyEncAlg.getParameters()).getAlgorithm().getId();
            PublicKey senderPublicKey = this.getSenderPublicKey(receiverPrivateKey, this.info.getOriginator(), prov);
            SecretKey agreedWrapKey = this.calculateAgreedWrapKey(wrapAlg, senderPublicKey, (PrivateKey)receiverPrivateKey, prov);
            return this.unwrapSessionKey(wrapAlg, agreedWrapKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", (Exception)e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException("originator key spec invalid.", (Exception)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", (Exception)e);
        }
        catch (Exception e) {
            throw new CMSException("originator key invalid.", e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient agreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier recKeyAlgId = agreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(recKeyAlgId, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

