/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.operator;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.oiw.OIWObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.RSASSAPSSparams;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x9.X9ObjectIdentifiers;
import cn.tca.TopBasicCrypto.operator.SignatureAlgorithmIdentifierFinder;
import cn.tca.TopBasicCrypto.util.Strings;
import cn.topca.core.ext.bc.asn1.gm.GMObjectIdentifiers;
import cn.topca.security.JCAJCEUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultSignatureAlgorithmIdentifierFinder
implements SignatureAlgorithmIdentifierFinder {
    private static Map<String, DERObjectIdentifier> algorithms = new HashMap<String, DERObjectIdentifier>();
    private static Set<DERObjectIdentifier> noParams = new HashSet<DERObjectIdentifier>();
    private static Map<String, RSASSAPSSparams> params = new HashMap<String, RSASSAPSSparams>();
    private static Set<ASN1ObjectIdentifier> pkcs15RsaEncryption = new HashSet<ASN1ObjectIdentifier>();
    private static Map<DERObjectIdentifier, DERObjectIdentifier> digestOids = new HashMap<DERObjectIdentifier, DERObjectIdentifier>();
    private static final DERObjectIdentifier ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption;
    private static final DERObjectIdentifier ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1;
    private static final DERObjectIdentifier ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1;
    private static final DERObjectIdentifier ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS;
    private static final DERObjectIdentifier ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94;
    private static final DERObjectIdentifier ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001;
    private static final DERObjectIdentifier ENCRYPTION_SM2 = GMObjectIdentifiers.sm2;

    private static AlgorithmIdentifier generate(String signatureAlgorithm) {
        String algorithmName = Strings.toUpperCase((String)signatureAlgorithm);
        DERObjectIdentifier sigOID = algorithms.get(algorithmName);
        if (sigOID == null) {
            if (!JCAJCEUtils.isValidIdentifier(algorithmName)) {
                throw new IllegalArgumentException("Unknown signature type requested: " + algorithmName);
            }
            sigOID = new DERObjectIdentifier(algorithmName);
        }
        AlgorithmIdentifier sigAlgId = noParams.contains(sigOID) ? new AlgorithmIdentifier(sigOID) : (params.containsKey(algorithmName) ? new AlgorithmIdentifier(sigOID, (DEREncodable)params.get(algorithmName)) : new AlgorithmIdentifier(sigOID, (DEREncodable)DERNull.INSTANCE));
        if (pkcs15RsaEncryption.contains(sigOID)) {
            AlgorithmIdentifier encAlgId = new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.rsaEncryption, (DEREncodable)new DERNull());
        } else {
            AlgorithmIdentifier encAlgId = sigAlgId;
        }
        if (sigAlgId.getAlgorithm().equals((Object)PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            AlgorithmIdentifier digAlgId = ((RSASSAPSSparams)sigAlgId.getParameters()).getHashAlgorithm();
        } else {
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(digestOids.get(sigOID), (DEREncodable)new DERNull());
        }
        return sigAlgId;
    }

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier hashAlgId, int saltSize) {
        return new RSASSAPSSparams(hashAlgId, new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.id_mgf1, (DEREncodable)hashAlgId), new DERInteger(saltSize), new DERInteger(1));
    }

    public AlgorithmIdentifier find(String sigAlgName) {
        return DefaultSignatureAlgorithmIdentifierFinder.generate(sigAlgName);
    }

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD2WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD5WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("MD5WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("SHA1WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA1WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA224WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA224WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA256WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA256WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA384WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA384WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA512WITHRSAENCRYPTION", (DERObjectIdentifier)PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA512WITHRSA", (DERObjectIdentifier)PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA1WITHRSAANDMGF1", (DERObjectIdentifier)PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA224WITHRSAANDMGF1", (DERObjectIdentifier)PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA256WITHRSAANDMGF1", (DERObjectIdentifier)PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA384WITHRSAANDMGF1", (DERObjectIdentifier)PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA512WITHRSAANDMGF1", (DERObjectIdentifier)PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", (DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        algorithms.put("RIPEMD160WITHRSA", (DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        algorithms.put("RIPEMD128WITHRSAENCRYPTION", (DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        algorithms.put("RIPEMD128WITHRSA", (DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        algorithms.put("RIPEMD256WITHRSAENCRYPTION", (DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        algorithms.put("RIPEMD256WITHRSA", (DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        algorithms.put("SHA1WITHDSA", (DERObjectIdentifier)X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("DSAWITHSHA1", (DERObjectIdentifier)X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("SHA224WITHDSA", (DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha224);
        algorithms.put("SHA256WITHDSA", (DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha256);
        algorithms.put("SHA384WITHDSA", (DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha384);
        algorithms.put("SHA512WITHDSA", (DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha512);
        algorithms.put("SHA1WITHECDSA", (DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("ECDSAWITHSHA1", (DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("SHA224WITHECDSA", (DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA224);
        algorithms.put("SHA256WITHECDSA", (DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA256);
        algorithms.put("SHA384WITHECDSA", (DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA384);
        algorithms.put("SHA512WITHECDSA", (DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA512);
        algorithms.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHGOST3410-94", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("SM3WITHSM2", (DERObjectIdentifier)GMObjectIdentifiers.sm3withSM2);
        algorithms.put("SHA1WITHSM2", (DERObjectIdentifier)GMObjectIdentifiers.sha1withSM2);
        algorithms.put("SHA256WITHSM2", (DERObjectIdentifier)GMObjectIdentifiers.sha256withSM2);
        algorithms.put("SM3WITHRSA", (DERObjectIdentifier)GMObjectIdentifiers.sm3withRSA);
        noParams.add((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA1);
        noParams.add((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA224);
        noParams.add((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA256);
        noParams.add((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA384);
        noParams.add((DERObjectIdentifier)X9ObjectIdentifiers.ecdsa_with_SHA512);
        noParams.add((DERObjectIdentifier)X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha224);
        noParams.add((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha256);
        noParams.add((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha384);
        noParams.add((DERObjectIdentifier)NISTObjectIdentifiers.dsa_with_sha512);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        pkcs15RsaEncryption.add(PKCSObjectIdentifiers.sha1WithRSAEncryption);
        pkcs15RsaEncryption.add(PKCSObjectIdentifiers.sha224WithRSAEncryption);
        pkcs15RsaEncryption.add(PKCSObjectIdentifiers.sha256WithRSAEncryption);
        pkcs15RsaEncryption.add(PKCSObjectIdentifiers.sha384WithRSAEncryption);
        pkcs15RsaEncryption.add(PKCSObjectIdentifiers.sha512WithRSAEncryption);
        pkcs15RsaEncryption.add(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        pkcs15RsaEncryption.add(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        pkcs15RsaEncryption.add(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        AlgorithmIdentifier sha1AlgId = new AlgorithmIdentifier((DERObjectIdentifier)OIWObjectIdentifiers.idSHA1, (DEREncodable)new DERNull());
        params.put("SHA1WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.creatPSSParams(sha1AlgId, 20));
        AlgorithmIdentifier sha224AlgId = new AlgorithmIdentifier((DERObjectIdentifier)NISTObjectIdentifiers.id_sha224, (DEREncodable)new DERNull());
        params.put("SHA224WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.creatPSSParams(sha224AlgId, 28));
        AlgorithmIdentifier sha256AlgId = new AlgorithmIdentifier((DERObjectIdentifier)NISTObjectIdentifiers.id_sha256, (DEREncodable)new DERNull());
        params.put("SHA256WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.creatPSSParams(sha256AlgId, 32));
        AlgorithmIdentifier sha384AlgId = new AlgorithmIdentifier((DERObjectIdentifier)NISTObjectIdentifiers.id_sha384, (DEREncodable)new DERNull());
        params.put("SHA384WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.creatPSSParams(sha384AlgId, 48));
        AlgorithmIdentifier sha512AlgId = new AlgorithmIdentifier((DERObjectIdentifier)NISTObjectIdentifiers.id_sha512, (DEREncodable)new DERNull());
        params.put("SHA512WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.creatPSSParams(sha512AlgId, 64));
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.sha224WithRSAEncryption, (DERObjectIdentifier)NISTObjectIdentifiers.id_sha224);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.sha256WithRSAEncryption, (DERObjectIdentifier)NISTObjectIdentifiers.id_sha256);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.sha384WithRSAEncryption, (DERObjectIdentifier)NISTObjectIdentifiers.id_sha384);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.sha512WithRSAEncryption, (DERObjectIdentifier)NISTObjectIdentifiers.id_sha512);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.md2WithRSAEncryption, (DERObjectIdentifier)PKCSObjectIdentifiers.md2);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.md4WithRSAEncryption, (DERObjectIdentifier)PKCSObjectIdentifiers.md4);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.md5WithRSAEncryption, (DERObjectIdentifier)PKCSObjectIdentifiers.md5);
        digestOids.put((DERObjectIdentifier)PKCSObjectIdentifiers.sha1WithRSAEncryption, (DERObjectIdentifier)OIWObjectIdentifiers.idSHA1);
        digestOids.put((DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128, (DERObjectIdentifier)TeleTrusTObjectIdentifiers.ripemd128);
        digestOids.put((DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160, (DERObjectIdentifier)TeleTrusTObjectIdentifiers.ripemd160);
        digestOids.put((DERObjectIdentifier)TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256, (DERObjectIdentifier)TeleTrusTObjectIdentifiers.ripemd256);
        digestOids.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, CryptoProObjectIdentifiers.gostR3411);
        digestOids.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, CryptoProObjectIdentifiers.gostR3411);
        digestOids.put((DERObjectIdentifier)GMObjectIdentifiers.sm3withSM2, (DERObjectIdentifier)GMObjectIdentifiers.sm3);
        digestOids.put((DERObjectIdentifier)GMObjectIdentifiers.sha1withSM2, (DERObjectIdentifier)GMObjectIdentifiers.sha1);
        digestOids.put((DERObjectIdentifier)GMObjectIdentifiers.sha256withSM2, (DERObjectIdentifier)GMObjectIdentifiers.sha256);
        digestOids.put((DERObjectIdentifier)GMObjectIdentifiers.sm3withRSA, (DERObjectIdentifier)GMObjectIdentifiers.sm3);
        digestOids.put((DERObjectIdentifier)GMObjectIdentifiers.sha1withRSA, (DERObjectIdentifier)GMObjectIdentifiers.sha1);
        digestOids.put((DERObjectIdentifier)GMObjectIdentifiers.sha256withRSA, (DERObjectIdentifier)GMObjectIdentifiers.sha256);
    }
}

