/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.operator.jcajce;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.operator.AsymmetricKeyUnwrapper;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.OperatorException;
import cn.topca.core.ext.bc.asn1.gm.GMObjectIdentifiers;
import cn.topca.core.ext.bc.jcajce.DefaultJcaJceHelper;
import cn.topca.core.ext.bc.jcajce.NamedJcaJceHelper;
import cn.topca.core.ext.bc.jcajce.ProviderJcaJceHelper;
import cn.topca.core.ext.bc.operator.jcajce.OperatorHelper;
import cn.topca.core.ext.bc.util.OIDUtils;
import cn.topca.crypto.Cipher;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class JceAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PrivateKey privKey;

    public JceAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey) {
        super(algorithmIdentifier);
        this.privKey = privKey;
    }

    public JceAsymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Key sKey = null;
            ASN1ObjectIdentifier algorithm = GMObjectIdentifiers.sm2.equals((Object)this.getAlgorithmIdentifier().getParameters()) ? (ASN1ObjectIdentifier)this.getAlgorithmIdentifier().getParameters() : this.getAlgorithmIdentifier().getAlgorithm();
            Cipher keyCipher = this.helper.createAsymmetricWrapper(algorithm);
            String keyAlgName = OIDUtils.getName(encryptedKeyAlgorithm.getAlgorithm().getId());
            try {
                keyCipher.init(4, this.privKey);
                sKey = keyCipher.unwrap(encryptedKey, keyAlgName, 3);
            }
            catch (GeneralSecurityException e) {
            }
            catch (IllegalStateException e) {
            }
            catch (UnsupportedOperationException e) {
            }
            catch (ProviderException e) {
                // empty catch block
            }
            if (sKey == null) {
                keyCipher.init(2, this.privKey);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), keyAlgName);
            }
            return new GenericKey(sKey);
        }
        catch (InvalidKeyException e) {
            throw new OperatorException("key invalid: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new OperatorException("illegal blocksize: " + e.getMessage(), (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new OperatorException("bad padding: " + e.getMessage(), (Throwable)e);
        }
    }
}

